% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_geo}
\alias{add_geo}
\title{Adding the geometry to the downloaded data for drawing maps}
\usage{
add_geo(data, ...)
}
\arguments{
\item{data}{a data set downloaded using the covid19br::downloadCovid19() function.}

\item{...}{further arguments passed to other methods.}
}
\value{
the data set with the added georeferenced data.
}
\description{
This function adds the necessary geometry for drawing maps to a given data set downloaded by the covid19br::downloadCovid19() function.
}
\details{
The function add_geo() was designed to work with the original names of the variables available in the data set downloaded by the covid19br::downloadCovid19(). For this reason, this function must be used before any change in such variable names.
}
\examples{
\donttest{
library(covid19br)

regions <- downloadCovid19(level = "regions")
regions_geo <- add_geo(regions)
}

}
\author{
Fabio N. Demarqui \email{fndemarqui@est.ufmg.br}
}
