% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid19sf_tests}
\alias{covid19sf_tests}
\title{San Francisco COVID-19 Tests}
\format{
An object class data.frame with 7 variables
\describe{
  \item{specimen_collection_date}{date which case was recorded in YYYY-MM-DD format.}
  \item{tests}{Daily tests count}
  \item{pos}{Number of positive cases}
  \item{pct}{Percentage of positive cases}
  \item{neg}{Number of negative cases}
  \item{indeterminate}{Number of indeterminate cases}
  \item{last_updated}{The table last update time in POSIX format}
  }
}
\source{
San Francisco, Department of Public Health - Population Health Division through San Francisco Opne Data protal \href{https://datasf.org/opendata/}{website}.
}
\usage{
covid19sf_tests
}
\description{
Case information on COVID-19 Laboratory testing.
This data includes a daily count of test results reported,
and how many of those were positive, negative, and indeterminate.
Reported tests include tests with a positive, negative or indeterminate result.
Indeterminate results, which could not conclusively determine whether COVID-19 virus
was present, are not included in the calculation of percent positive.
Testing for the novel coronavirus is available through commercial, clinical,
and hospital laboratories, as well as the SFDPH Public Health Laboratory. More information about the data available \href{https://data.sfgov.org/COVID-19/Covid-19-Tests/nfpa-mg4g}{here}
}
\details{
A daily COVID-19 testing results report
}
\examples{
data(covid19sf_tests)

head(covid19sf_tests)
}
\keyword{COVID19}
\keyword{datasets}
\keyword{summary}
\keyword{tests}
