% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid19sf_hospitalizations}
\alias{covid19sf_hospitalizations}
\title{San Francisco COVID-19 Hospitalizations}
\format{
An object class data.frame with 5 variables
\describe{
  \item{reportdate}{date which case was recorded in YYYY-MM-DD format.}
  \item{hospital}{The hospital which patients were admitted, currently it labeled under "All SF Hospitals" }
  \item{dphcategory}{The type of hospitalization bed, either an acute care bed (a regular hospital bed), or an intensive care unit (ICU) bed}
  \item{covidstatus}{The patient diagnostic, either PUI (Patient Under Investigation) or COVID+ (positive case)}
  \item{patientcount}{Daily cases count}
  }
}
\source{
San Francisco, Department of Public Health - Population Health Division through San Francisco Opne Data protal \href{https://datasf.org/opendata/}{website}.
}
\usage{
covid19sf_hospitalizations
}
\description{
Count of COVID+ patients admitted to the hospital.
Patients who are hospitalized and test positive for COVID-19 may be admitted to an
acute care bed (a regular hospital bed), or an intensive care unit (ICU) bed.
This data shows the daily total count of COVID+ patients in these two bed types,
and the data reflects totals from all San Francisco Hospitals. More information about the data available \href{https://data.sfgov.org/COVID-19/COVID-19-Hospitalizations/nxjg-bhem}{here}
}
\details{
Each record represents how many people were hospitalized on the date recorded in
either an ICU bed or acute care bed (shown as Med/Surg under DPHCategory field)
}
\examples{
data(covid19sf_hospitalizations)

head(covid19sf_hospitalizations)
}
\keyword{COVID19}
\keyword{datasets}
\keyword{hospital}
\keyword{summary}
