% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covidcast.R
\docType{package}
\name{covidcast}
\alias{covidcast}
\title{covidcast: Client for Delphi's COVIDcast API}
\description{
The covidcast package provides access to numerous COVID-19 data streams,
updated daily, covering the United States of America. These include publicly
reported cases and deaths data, along with data the Delphi research group
collects or obtains from partners.
}
\section{Finding data sources and documentation}{


The COVIDcast API includes:
\itemize{
\item publicly reported COVID case and death data
\item insurance claims data reporting on COVID-related doctor's visits and
hospitalizations, obtained from health partners
\item aggregate results from massive COVID symptom surveys conducted by Delphi
\item mobility data aggregated from SafeGraph
\item symptom search trends from Google
}

and numerous other important signals, most available daily at the county
level.

Each data stream is identified by its data source and signal names. These are
documented on the COVIDcast API website:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_signals.html}

Each data stream has a page giving detailed technical documentation on how
the data is collected, how it is aggregated, and any limitations or known
problems with the data.
}

\section{Getting started}{


We recommend browsing the vignettes, which includes numerous examples:
\code{browseVignettes(package = "covidcast")}.

See also \code{covidcast_signal()} for details on how to obtain COVIDcast data as
a data frame.
}

