% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covidcast.R
\name{covidcast_meta}
\alias{covidcast_meta}
\title{Obtain COVIDcast metadata}
\usage{
covidcast_meta()
}
\value{
Data frame containing one row per signal, with the following columns:
\item{data_source}{Data source name.}
\item{signal}{Signal name.}
\item{min_time}{First day for which this signal is available.}
\item{max_time}{Most recent day for which this signal is available.}
\item{geo_type}{Geographic level for which this signal is available, such
as county, state, msa, or hrr. Most signals are available at multiple
geographic levels and will hence be listed in multiple rows with their
own metadata.}
\item{time_type}{Temporal resolution at which this signal is reported.
"day", for example, means the signal is reported daily.}
\item{num_locations}{Number of distinct geographic locations available for
this signal. For example, if \code{geo_type} is county, the number of counties
for which this signal has ever been reported.}
\item{min_value}{Smallest value that has ever been reported.}
\item{max_value}{Largest value that has ever been reported.}
\item{mean_value}{Arithmetic mean of all reported values.}
\item{stdev_value}{Sample standard deviation of all reported values.}
\item{max_issue}{Most recent issue date for this signal.}
\item{min_lag}{Smallest lag from observation to issue, in \code{time_type} units}
\item{max_lag}{Largest lag from observation to issue, in \code{time_type} units}
}
\description{
Obtains a data frame of metadata describing all publicly available data
streams from the COVIDcast API.
}
\references{
COVIDcast API sources and signals documentation:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_signals.html}
}
\seealso{
\code{\link[=summary.covidcast_meta]{summary.covidcast_meta()}}
}
