% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared-methods.R
\name{DataClass}
\alias{DataClass}
\title{R6 Class containing non-dataset specific methods}
\description{
A parent class containing non-dataset specific methods.
}
\details{
All data sets have shared methods for extracting geographic codes,
downloading, processing, and returning data. These functions are contained
within this parent class and so are accessible by all data sets which
inherit from here. Individual data sets can overwrite any functions or
fields providing they define a method with the same name, and can be
extended with additinal functionality. See the individual method documentaion
for further details.
}
\seealso{
Data interface functions
\code{\link{CountryDataClass}},
\code{\link{get_available_datasets}()},
\code{\link{get_national_data}()},
\code{\link{get_regional_data}()},
\code{\link{initialise_dataclass}()}
}
\concept{interface}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{origin}}{the origin of the data source. For regional data sources
this will usually be the name of the country.}

\item{\code{data}}{Once initialised, a list of named data frames: raw
(list of named raw data frames) clean (cleaned data) and processed
(processed data). Data is accessed using \verb{$data}.}

\item{\code{supported_levels}}{A list of supported levels.}

\item{\code{supported_region_names}}{A list of region names in order of level.}

\item{\code{supported_region_codes}}{A list of region codes in order of level.}

\item{\code{region_name}}{string Name for the region column, e.g. 'region'.
This field is filled at initialisation with the region name for the
specified level (supported_region_names$level).}

\item{\code{code_name}}{string Name for the codes column, e.g. 'iso_3166_2'
Filled at initialisation with the code name associated with the
requested level (supported_region_codes$level).}

\item{\code{codes_lookup}}{string or tibble Region codes for the target origin
filled by origin specific codes in
\href{#method-set_region_codes}{\code{set_region_codes()}}}

\item{\code{data_urls}}{List of named common and shared url links to raw data.
Prefers shared if there is a name conflict.}

\item{\code{common_data_urls}}{List of named links to raw data that are common
across levels. The first entry should be named main.}

\item{\code{level_data_urls}}{List of named links to raw data that are level
specific. Any urls that share a name with a url from
\code{common_data_urls} will be selected preferentially. Each top level
list should be named after a supported level.}

\item{\code{source_data_cols}}{existing columns within the raw data}

\item{\code{level}}{target region level. This field is filled at initialisation
using user inputs or defaults in \verb{$new()}}

\item{\code{totals}}{Boolean. If TRUE, returns totalled data per region
up to today's date. This field is filled at initialisation using user
inputs or defaults in \verb{$new()}}

\item{\code{localise}}{Boolean. Should region names be localised.
This field is filled at initialisation using user inputs or defaults
in \verb{$new()}}

\item{\code{verbose}}{Boolean. Display information at various stages.
This field is filled at initialisation. using user inputs or defaults
in \verb{$new()}}

\item{\code{steps}}{Boolean. Keep data from each processing step.
This field is filled at initialisation.using user inputs or defaults
in \verb{$new()}}

\item{\code{target_regions}}{A character vector of regions to filter for. Used
by the \verb{filter method}.}

\item{\code{process_fns}}{array, additional, user supplied functions to process
the data.}

\item{\code{filter_level}}{Character The level of the data to filter at.
Defaults to the target level.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-set_region_codes}{\code{DataClass$set_region_codes()}}
\item \href{#method-new}{\code{DataClass$new()}}
\item \href{#method-download}{\code{DataClass$download()}}
\item \href{#method-clean}{\code{DataClass$clean()}}
\item \href{#method-clean_common}{\code{DataClass$clean_common()}}
\item \href{#method-available_regions}{\code{DataClass$available_regions()}}
\item \href{#method-filter}{\code{DataClass$filter()}}
\item \href{#method-process}{\code{DataClass$process()}}
\item \href{#method-get}{\code{DataClass$get()}}
\item \href{#method-return}{\code{DataClass$return()}}
\item \href{#method-summary}{\code{DataClass$summary()}}
\item \href{#method-clone}{\code{DataClass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_region_codes"></a>}}
\if{latex}{\out{\hypertarget{method-set_region_codes}{}}}
\subsection{Method \code{set_region_codes()}}{
Place holder for custom country specific function to load
region codes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$set_region_codes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize function used by all \code{DataClass} objects.
Set up the \code{DataClass} class with attributes set to input parameters.
Should only be called by a \code{DataClass} class object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$new(
  level = "1",
  filter_level,
  regions,
  totals = FALSE,
  localise = TRUE,
  verbose = TRUE,
  steps = FALSE,
  get = FALSE,
  process_fns
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{A character string indicating the target administrative
level of the data with the default being "1". Currently supported
options are level 1 ("1) and level 2 ("2").}

\item{\code{filter_level}}{A character string indicating the level to filter at.
Defaults to the level of the data if not specified and if not otherwise
defined in the class.
Use \code{get_available_datasets()} for supported options by dataset.}

\item{\code{regions}}{A character vector of target regions to be assigned to
the\code{target_regions} field if present.}

\item{\code{totals}}{Logical, defaults to FALSE. If TRUE, returns totalled
data per region up to today's date. If FALSE, returns the full dataset
stratified by date and region.}

\item{\code{localise}}{Logical, defaults to TRUE. Should region names be
localised.}

\item{\code{verbose}}{Logical, defaults to TRUE. Should verbose processing}

\item{\code{steps}}{Logical, defaults to FALSE. Should all processing and
cleaning steps be kept and output in a list.}

\item{\code{get}}{Logical, defaults to FALSE. Should the class \code{get} method be
called (this will download, clean, and process data at initialisation).}

\item{\code{process_fns}}{Array, additional functions to process the data.
Users can supply their own functions here which would act on clean data
and they will be called alongside our default processing functions.
The default optional function added is \code{set_negative_values_to_zero}.
if process_fns is not set (see \code{process_fns} field for all defaults).
If you want to keep this when supplying your own processing functions
remember to add it to your list also. If you feel you have created a
cool processing function that others could benefit from please submit a
Pull Request to our \href{https://github.com/epiforecasts/covidregionaldata}{github repository}
and we will consider adding it to the package.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-download"></a>}}
\if{latex}{\out{\hypertarget{method-download}{}}}
\subsection{Method \code{download()}}{
Download raw data from \code{data_urls}, stores a named list
of the \code{data_url} name and the corresponding raw data table in
\code{data$raw}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$download()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean"></a>}}
\if{latex}{\out{\hypertarget{method-clean}{}}}
\subsection{Method \code{clean()}}{
Cleans raw data (corrects format, converts column types,
etc). Works on raw data and so should be called after
\href{#method-download}{\code{download()}}
Calls the specific class specific cleaning method (\code{clean_common})
followed by level specific cleaning methods.
\code{clean_level_[1/2]}. Cleaned data is stored in \code{data$clean}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$clean()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean_common"></a>}}
\if{latex}{\out{\hypertarget{method-clean_common}{}}}
\subsection{Method \code{clean_common()}}{
Cleaning methods that are common across a class.
By default this method is empty as if any code is required it should be
defined in a child class specific \code{clean_common} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$clean_common()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-available_regions"></a>}}
\if{latex}{\out{\hypertarget{method-available_regions}{}}}
\subsection{Method \code{available_regions()}}{
Show regions that are available to be used for
filtering operations. Can only be called once \code{clean()} has been
called. Filtering level is determined by checking the \code{filter_level}
field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$available_regions(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{A character string indicating the level to filter at.
Defaults to using the \code{filter_level} field if not specified}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filter"></a>}}
\if{latex}{\out{\hypertarget{method-filter}{}}}
\subsection{Method \code{filter()}}{
Filter cleaned data for a specific region  To be called
after \href{#method-clean}{\code{clean()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$filter(regions, level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{regions}}{A character vector of target regions. Overrides the
current class setting for \code{target_regions}.}

\item{\code{level}}{Character The level of the data to filter at. Defaults to
the lowest level in the data.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-process"></a>}}
\if{latex}{\out{\hypertarget{method-process}{}}}
\subsection{Method \code{process()}}{
Processes data by adding and calculating absent columns.
Called on clean data (after \href{#method-clean}{\code{clean()}}).
Some countries may have data as new events (e.g. number of
new cases for that day) whilst others have a running total up to that
date. Processing calculates these based on what the data comes with
via the functions \code{region_dispatch()} and \code{process_internal()},
which does the following:
\itemize{
\item{Adds columns not present in the data \code{add_extra_na_cols()}}
\item{Ensures there are no negative values
\code{set_negative_values_to_zero()}}
\item{Removes NA dates \code{fill_empty_dates_with_na()}}
\item{Calculates cumulative data \code{complete_cumulative_columns()}}
\item{Calculates missing columns from existing ones
\code{calculate_columns_from_existing_data()}}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$process(process_fns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{process_fns}}{Array, additional functions to process the data.
Users can supply their own functions here which would act on clean data
and they will be called alongside our default processing functions.
The default optional function added is \code{set_negative_values_to_zero}.
if process_fns is not set (see \code{process_fns} field for all defaults).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Get data related to the data class. This runs each distinct
step in the workflow in order.
Internally calls \href{#method-download}{\code{download()}},
\href{#method-clean}{\code{clean()}},
\href{#method-filter}{\code{filter()}} and
\href{#method-process}{\code{process()}}
\code{download}, \code{clean}, \code{filter} and \code{process} methods.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$get()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-return"></a>}}
\if{latex}{\out{\hypertarget{method-return}{}}}
\subsection{Method \code{return()}}{
Return data. Designed to be called after
\href{#method-process}{\code{process()}}
this uses the steps argument to return either a
list of all the data preserved at each step or just the processed data.
For most datasets a custom method should not be needed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$return()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary"></a>}}
\if{latex}{\out{\hypertarget{method-summary}{}}}
\subsection{Method \code{summary()}}{
Create a table of summary information for the data set
being processed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a single row summary tibble containing the origin of the
data source, class, level 1 and 2 region names, the type of data,
the urls of the raw data and the columns present in the raw data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
