% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IG.R
\name{rIG}
\alias{rIG}
\title{Simulation of non-normal data}
\usage{
rIG(
  N,
  sigma.target,
  skewness,
  excesskurtosis,
  reps = 1,
  typeA = c("symm", "triang")
)
}
\arguments{
\item{N}{Number of observations to simulate.}

\item{sigma.target}{Target population covariance matrix}

\item{skewness}{Target skewness}

\item{excesskurtosis}{Target excess kurtosis}

\item{reps}{Number of simulated samples}

\item{typeA}{Symmetrical (default) or triangular A matrix}
}
\value{
A list of simulated samples
}
\description{
Using the IG method to simulate non-normal data
}
\examples{
set.seed(1234)
model <- '
 # measurement model
   ind60 =~ x1 + x2 + x3
   dem60 =~ y1 + y2 + y3 + y4
   dem65 =~ y5 + y6 + y7 + y8
 # regressions
   dem60 ~ ind60
   dem65 ~ ind60 + dem60
 # residual correlations
   y1 ~~ y5
   y2 ~~ y4 + y6
   y3 ~~ y7
   y4 ~~ y8
   y6 ~~ y8'
fit  <- lavaan::sem(model, data=lavaan::PoliticalDemocracy)
population.sigma <- lavaan::lavInspect(fit, "sigma.hat")
population.skew  <- c(0, 0, 0, 0, 1, 1, 1, 1, 2,2,2 )
population.excesskurt <- c( 1 , 1, 1, 1, 3, 3, 3, 3, 7, 7, 7)
my.samples <- rIG(N=10^3, sigma=population.sigma,
        skewness=population.skew,
        excesskurt=population.excesskurt,
        reps=5)
}
\references{
Foldnes, N. and Olson, U. H. (2016). A simple simulation technique for nonnormal data with prespecified skewness,
            kurtosis, and covariance matrix. Multivariate behavioral research, 51(2-3), 207-219
}
\author{
Njål Foldnes  (\email{njal.foldnes@gmail.com})
}
