% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.margeffect.R
\name{make.margeffect}
\alias{make.margeffect}
\title{Calculating a simulated marginal effect}
\usage{
make.margeffect(baseline, xb, covariate = 1, low = 0, high = 1,
  compare = median)
}
\arguments{
\item{baseline}{The baseline hazard functions, output by \code{\link[coxed]{baseline.build}}}

\item{xb}{The simulated data, output by \code{\link[coxed]{generate.lm}}}

\item{covariate}{Specification of the column number of the covariate in the \code{X} matrix for which to generate a simulated marginal effect (default is 1).
The marginal effect is the difference in expected duration when the covariate is fixed at a high value and the expected duration when the covariate is fixed
at a low value}

\item{low}{The low value of the covariate for which to calculate a marginal effect}

\item{high}{The high value of the covariate for which to calculate a marginal effect}

\item{compare}{The statistic to employ when examining the two new vectors of expected durations (see details for \code{\link[coxed]{sim.survdata}}).  The default is \code{median}}
}
\value{
A list with three items:
\tabular{ll}{
\code{marg.effect} \tab A scalar containing the simulated marginal effect\cr
\code{data.low} \tab The durations and covariates when the covariate of interest is set to the low value \cr
\code{data.high} \tab The durations and covariates when the covariate of interest is set to the high value \cr
}
}
\description{
This function is called by \code{\link[coxed]{sim.survdata}} and is not intended to be used by itself.
}
\details{
The idea is to simulate a marginal change in duration so that researchers can compare the performance of
estimators of this statistic using simulated data.

The function calculates simulated durations for each observation conditional on a baseline hazard function
and exogenous covariates and coefficients.  The \code{covariate} argument specifies the variable in the X matrix to
vary so as to measure the marginal effect.  First the covariate is set to the value specified in \code{low} for all
observations, then to the value specified in \code{high} for all observations.  Given each value, new durations are
drawn. The durations when the covariate equals the low value are subtracted from the durations when the covariate
equals the high value.  The marginal effect is calculated by employing the statistic given by \code{compare}, which
is \code{median} by default.
}
\examples{
T <- 100
N <- 1000
X <- as.matrix(data.frame(X1=rnorm(N), X2=rnorm(N), X3=rnorm(N)))
beta <- as.matrix(rnorm(3))
baseline <- baseline.build(T=T, knots=8, spline=TRUE)
xb <- generate.lm(baseline, X=X, beta=beta, N=N, censor=.1, type="none")
me <- make.margeffect(baseline, xb, covariate=1, low=0, high=1)
me$marg.effect
}
\seealso{
\code{\link[coxed]{baseline.build}}, \code{\link[coxed]{generate.lm}}, \code{\link[coxed]{sim.survdata}}
}
\author{
Jonathan Kropko <jkropko@virginia.edu> and Jeffrey J. Harden <jharden2@nd.edu>
}
