% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.predict.R
\name{rank.predict}
\alias{rank.predict}
\title{Generate predicted ranks for new observations given a new covariate profile}
\usage{
rank.predict(x, v, ties.method = "random", warn = TRUE)
}
\arguments{
\item{x}{A vector of linear predictors for the estimation sample}

\item{v}{A vector of linear predictors for the new data}

\item{ties.method}{A character string specifying how ties are treated,
see ‘Details’ in the documentation for \code{\link[base]{rank}}; can be
abbreviated.}

\item{warn}{If \code{TRUE} the function warns the user when linear predictors in the new data are greater than
or less than all of the linear predictors in the estimation sample}
}
\value{
A numeric vector containing the predicted ranks for the observations in \code{x}.
}
\description{
This function is called by \code{\link[coxed]{coxed}} when \code{method="gam"} and new data
are specified, and is not intended to be used by itself.
}
\details{
The purpose of \code{rank.predict} is to determine for a single new observation what the rank of that
observation's linear predictor would have been had the observation been in the original estimation sample.
It calculates the predicted rank by appending the new observation to the vector of linear predictors for the
estimation sample and calculating the \code{\link[base]{rank}} of the observation in the new vector. If
the new data contain more than one observation, \code{rank.predict} calculates the predicted rank for each
observation independently, without taking the other observations in the new data into account.

Any observation with a linear predictor less than the minimum linear predictor in the estimation sample will have a predicted
rank of 1; any observation with a linear predictor greater than the maximum linear predictor in the estimation
sample will have a predicted rank of \code{length(v)}. If either condition exists, the function provides a warning.
}
\examples{
estimationLPs <- rnorm(20)
cbind(estimationLPs, rank(estimationLPs))
newLPs <- rnorm(5)
newLP.rank <- rank.predict(x=newLPs, v=estimationLPs)
cbind(newLPs, newLP.rank)
}
\seealso{
\code{\link[coxed]{coxed}}, \code{\link[base]{rank}}
}
\author{
Jonathan Kropko <jkropko@virginia.edu> and Jeffrey J. Harden <jharden2@nd.edu>
}
