% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcbs(MA).R
\name{Bin_segMA}
\alias{Bin_segMA}
\title{Most recent changepoints from dcbs method using censored MA timeseries.}
\usage{
Bin_segMA(data, beta)
}
\arguments{
\item{data}{a censored data matrix obtained from MA1.data.}

\item{beta}{threshold for testing whether or not a change is
significant, default 10.}
}
\value{
indicates the most recent changepoint in each series.
}
\description{
Detecting most recent changepoints from double CUSUM
binary segmentation algorithm (DCBS) method (Cho, 2016) after
generating censored data from MA model.
}
\examples{
library(cpcens)
#example(right censoring)
sim=MA1.data(n = 500, N = 100, K = 5, eps = 1,
rho = 0.4, mu = 0, siga = 1, rates = c(NA, 0.4), Mrate = 0)
data=sim$data
ans = Bin_segMA(data,beta=10)
}
\references{
Cho, H. (2016). Change-point detection in panel data via double CUSUM statistic.
Electronic Journal of Statistics, 10(2):2000–2038.
}
\seealso{
MA1.data
}
