% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv(AR).R
\name{PELT.MVar}
\alias{PELT.MVar}
\title{Most recent changepoints from MV method using censored AR timeseries.}
\usage{
PELT.MVar(data, beta = 101 * log(dim(data)[2]))
}
\arguments{
\item{data}{a censored data matrix obtained from AR1.data .}

\item{beta}{default 101*log(dim(data)[2])). Here dim(data)[2] means consider
size(length) of series (n).}
}
\value{
indicates the most recent changepoint in each series .
}
\description{
Detecting most recent changepoints from MV methd (Lavielle and Teyssiere, 2006) deal with
multivariate data which is modeling the data within each segment as a
 multivariate (MV) Gaussian having a given covariance
  after generating censored data from AR model.
}
\examples{
# example (Right censoring)
library(cpcens)
# The size of series(n) should be greater than 200.
sim=AR1.data(n = 500, N = 100, K = 5, eps = 1,
rho = 0.6, mu = 0, siga = 1, rates = c(NA, 0.2), Mrate = 0)
data=sim$data
N=100
pmv = PELT.MVar( data , 101*log(dim(data)[2]) )
mv.chpts =  rep( rev( pmv$cpts )[1] , N )
}
\references{
Lavielle, M. and Teyssiere, G. (2006). Detection of multiple changepoints in multivariate
time series.Lithuanian Mathematical Journal, 46(3):287-306
}
\seealso{
AR1.data
}
