% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg(AR).R
\name{PELT.ar}
\alias{PELT.ar}
\title{Most recent changepoints from AGG method using censored AR timeseries.}
\usage{
PELT.ar(data, pen = 200 * log(dim(data)[2]))
}
\arguments{
\item{data}{a censored data matrix obtained from AR1.data . And then we add this data matrix column wise and
use this as first argument in PELT.ar function.}

\item{pen}{penalty term, default 200*log(dim(data)[2]). Here dim(data)[2] means
consider length of series (n). The PELT function return cpts (Vector
of changepoints in segmentation) and F (optimal cost of segmenting series upto time t).}
}
\value{
indicates the most recent changepoint in each series .
}
\description{
Detecting most recent changepoints uing AGG method (detect
 changepoint in univariate time series)
 after generating censored data from AR model. We use PELT
 for segmenting a time series into changing mean, assuming normally
 distributed observations with changing mean but constant variance.
}
\examples{
#example
library(cpcens)
# The size of series(n) should be greater than 200.
sim=AR1.data(n = 500, N = 100, K = 5, eps = 1,
  rho = 0.6, mu = 0, siga = 1, rates = c(NA, 0.2), Mrate = 0)
data=sim$data
N=100
agg = apply( data , 2 , sum )
pagg = PELT.ar( agg , 200*log(dim(data)[2]) )
agg.chpts = rep( rev( pagg$cpts )[1] , N )
}
\seealso{
AR1.data
}
