% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indma(PELT).R
\name{indMA}
\alias{indMA}
\title{Most recent changepoints from ind method using censored MA timeseries.}
\usage{
indMA(data, pen = 0)
}
\arguments{
\item{data}{a censored data matrix obtained from MA1.data.}

\item{pen}{default 2*log(n). If pen is equal to zero , penalty term will be equal
to 2*log(n)}
}
\value{
indicates the most recent changepoint in each series.
}
\description{
Detecting most recent changepoints from ind method (analyzes
 all the series independently in the panel data and in
 each given series estimate the most recent changepoint) after
generating censored data from MA model. PELT is used for segmenting a time series
 into changing means, assumes normally distributed observations
with changing mean but constant variance
}
\examples{
#Default example
library(cpcens)
sim=MA1.data()
data=sim$data
ans = indMA(data,pen)
#example(right censoring)
# The size of series(n) should be greater than 200.
sim=MA1.data(n = 500, N = 100, K = 5, eps = 1,
rho = 0.6, mu = 0, siga = 1, rates = c(NA, 0.2), Mrate = 0)
data=sim$data
ans = indMA(data,pen=0)
}
\seealso{
MA1.data
}
