% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdotplot.R
\name{cdotplot}
\alias{cdotplot}
\title{Circular Stacked Dot Plot}
\usage{
cdotplot(x, nbins = 36, radius = 1, unit = NA, area.prop = TRUE,
  total.area = 1, m = NA, col = "lightblue", border = "skyblue4",
  xlim = NULL, ylim = NULL, main = NULL, x.legend = "bottomright",
  y.legend = NULL)
}
\arguments{
\item{x}{a circular data object that is fully defined by the user.}

\item{nbins}{the number of bins of the circular histogram.  Internally,
it is rounded to a multiple of 4.}

\item{radius}{the radius of the reference circle.  If \code{radius = 0},
a rose diagram is produced; if \code{radius > 0}, a circular histogram
is produced outside the reference circle.}

\item{unit}{the number of observations represented by each dot.  If
\code{unit > 1}, it means that each dot represents multiple
observations.}

\item{area.prop}{logical; if \code{TRUE}, an area-proportional
transformation is applied; if \code{FALSE}, a height-proportional
transformationis applied.}

\item{total.area}{a positive number specifying the total area under the
density curve. If \code{total.area = NULL}, no scaling is applied, the
plot is in the original scale. If \code{area.prop = TRUE}, the total area 
is automatically unity without scaling.}

\item{m}{the number of points within each bin to plot the circular dot
plot. The larger the number is, the smoother the plot looks.}

\item{col}{the color to fill the bars.}

\item{border}{the color of the border around the bars.}

\item{xlim}{numeric vectors of length 2, giving the x coordinates
ranges.}

\item{ylim}{numeric vectors of length 2, giving the y coordinates
ranges.}

\item{main}{the main title (on top)}

\item{x.legend}{x coordinate to plot the legend.}

\item{y.legend}{y coordinate to plot the legend.}
}
\description{
Function \code{cdotplot} can be used to plot 2-dimensional 
  stacked dot plot for circular data.
}
\details{
If the number of observations is relatively small, 
the usual circular stacked dot plot can be used with \code{unit = 1}.
If the dataset is large, the dots may become too dense to visualize or count.
Setting \code{unit} to be any positive integer to allow each dot to represent more than one observation.
If the number of observations in one bin is not a multiple of the specified unit, 
a partial dot can be used to represent the remainder at the top of the bin.
}
\examples{
# 30 observations from two von Mises distributions
library(circular)
x = c(rvonmises(10, circular(pi/4), 5), rvonmises(20, circular(pi), 20))
cdotplot(x)                 # area-proportional dot plot
cdotplot(x, area = FALSE)   # height-proportional dot plot

# 900 observations from two von Mises distributions
y = c(rvonmises(300, circular(pi/4), 5), rvonmises(600, circular(pi), 20))
cdotplot(y, nbins=76, unit = 10)      # area-proportional (partial) dot plot 
cdotplot(y, nbins=76, unit = 10, area = FALSE) # height-proportional

}
\references{
Xu, D. and Wang, Y. (2019) Area-proportional Visualization for 
Circular Data (submitted).
}
\seealso{
\code{\link{cbarplot}}, \code{\link{cdensity}}, \code{\link{chist}}
}
\author{
Danli Xu <dxu452@aucklanduni.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}
\keyword{circular}
\keyword{dot}
\keyword{plot}
\keyword{stacked}
