% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,cpop.class-method}
\title{Summarise a cpop analysis}
\usage{
\S4method{summary}{cpop.class}(object)
}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{cpop}}.}
}
\description{
Summary method for results produced by \code{\link{cpop}}.
}
\examples{
library(cpop)

# simulate data with change in gradient
set.seed(1)
x <- (1:50/5)^2
y <- simchangeslope(x,changepoints=c(10,50),change.slope=c(0.25,-0.25),sd=1)

# determine changepoints
res <- cpop(y,x,beta=2*log(length(y)))

# display a summary of the results
summary(res)
}
