% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice_after.R
\name{splice_after}
\alias{splice_after}
\alias{splice_after,CppForwardList-method}
\title{Move elements}
\usage{
splice_after(x, y, x_position, y_from, y_to)
}
\arguments{
\item{x}{A CppForwardList object to which to add elements.}

\item{y}{A CppForwardList object, of the same data type as \code{x}, from which to extract elements.}

\item{x_position}{Index after which to insert elements in \code{x}.}

\item{y_from}{Index after which to extract elements from \code{y}.}

\item{y_to}{Index of the last element to extract from \code{y}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Move elements from one forward list to another forward list by reference.
}
\details{
Indices start at 1, which is also the minimum value permitted. Thus, the current implementation in this package does not allow to move the 
first element of \code{y}.
}
\examples{
x <- cpp_forward_list(4:9)
x
# 4 5 6 7 8 9

y <- cpp_forward_list(10:12)
y
# 10 11 12

splice_after(x, y, 3, 1, 3)
x
# 4 5 6 11 12 7 8 9
y
# 10

}
\seealso{
\link{merge}, \link{splice}.
}
