% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{[,CppMap-method}
\alias{[,CppMap-method}
\alias{[,CppUnorderedMap-method}
\alias{[,CppVector-method}
\alias{[,CppDeque-method}
\title{Access or insert elements without bounds checking}
\usage{
\S4method{[}{CppMap}(x, i)

\S4method{[}{CppUnorderedMap}(x, i)

\S4method{[}{CppVector}(x, i)

\S4method{[}{CppDeque}(x, i)
}
\arguments{
\item{x}{A CppMap, CppUnorderedMap, CppVector, or CppDeque object.}

\item{i}{A key (CppMap, CppUnorderedMap) or index (CppVector, CppDeque).}
}
\value{
Returns the value associated with \code{i}.
}
\description{
Read or insert a value by key in a CppMap or CppUnorderedMap. Read a value by index in a CppVector or CppDeque.
}
\details{
In the two associative container types (CppMap, CppUnorderedMap), \code{[]} accesses a value by its key. If the key does not exist, it enters 
the key with a default value into the container. The default value is 0 for integer and double, an empty string for string, and \code{FALSE} for 
boolean.

In the two sequence container types (CppVector, CppDeque), \code{[]} accesses a value by its index. If the index is outside the container, this crashes 
the program.

\link{at} and \code{[]} both access elements. Unlike \code{[]}, \link{at} checks the bounds of the container and throws an error, if the element does 
not exist.
}
\examples{
m <- cpp_map(4:6, seq.int(0, 1, by = 0.5))
m
# [4,0] [5,0.5] [6,1]

m[6L]
# [1] 1

m
# [4,0] [5,0.5] [6,1] 

m[8L]
# [1] 0

m
# [4,0] [5,0.5] [6,1] [8,0]

v <- cpp_vector(4:6)
v
# 4 5 6

v[1L]
# [1] 4

v
# 4 5 6

}
\seealso{
\link{at}, \link{back}, \link{contains}, \link{front}, \link{top}.
}
