% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimap.R
\name{cpp_multimap}
\alias{cpp_multimap}
\title{Create multimap}
\usage{
cpp_multimap(keys, values)
}
\arguments{
\item{keys}{An integer, numeric, character, or logical vector.}

\item{values}{An integer, numeric, character, or logical vector.}
}
\value{
Returns a CppMultimap object referencing a multimap in C++.
}
\description{
Create a multimap. Multimaps are key-value pairs sorted by non-unique keys.
}
\details{
Multimaps are associative containers. They do not provide random access through an index. I.e. \code{m[2]} does not return the second element.

C++ multimap methods implemented in this package are \link{clear}, \link{contains}, \link{count}, \link{emplace}, \link{empty}, \link{erase}, 
\link{insert}, \link{max_size}, \link{merge}, and \link{size}. The package also adds the \link{==} operator and various helper functions (\link{print}, 
\link{to_r}, \link{type}).

All object-creating methods in this package begin with \code{cpp_} to avoid clashes with functions from other packages, such as \code{utils::stack} and 
\code{base::vector}.
}
\examples{
m <- cpp_multimap(4:6, seq.int(1, by = 0.5, length.out = 3L))
m
# [4,1] [5,1.5] [6,2]

insert(m, seq.int(100, by = 0.1, length.out = 3L), 5:7)
m
# [4,1] [5,1.5] [5,100] [6,2] [6,100.1] [7,100.2]

print(m, from = 6)
# [6,2] [6,100.1] [7,100.2]

m <- cpp_multimap(c("world", "hello", "there", "world"), 3:6)
m
# ["hello",4] ["there",5] ["world",3] ["world",6]

erase(m, "world")
m
# ["hello",4] ["there",5]

}
\seealso{
\link{cpp_map}, \link{cpp_unordered_map}, \link{cpp_unordered_multimap}.
}
