% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lucky.R
\name{lucky}
\alias{lucky}
\title{Random colour gradient!}
\usage{
lucky(
  n = 100,
  colorRampPalette = FALSE,
  rev = FALSE,
  message = TRUE,
  nseed,
  frgb = rep(1, 3)
)
}
\arguments{
\item{n}{integer; number of colors}

\item{colorRampPalette}{Logical; to be used in sf and mapview.}

\item{rev}{Logical; to internally revert order of rgb color vectors.}

\item{message}{Logical; for printing or not the name of the colour gradient}

\item{nseed}{integer; for reproducing the same colour gradient.
See \code{\link{set.seed}}}

\item{frgb}{Numeric; vector of 3 to change internal rgb composition
The order is red, green, blue}
}
\value{
A RANDOM colour palette function including name of the colour gradient
and number.
}
\description{
Based on "I'm Feeling Lucky" from Google. As this package includes 7140
colour gradients, it might be hard to find the 'right'
}
\details{
The cpt-city web archive comes from:
http://soliton.vm.bytemark.co.uk/pub/cpt-city/index.html
}
\examples{
{
library(cptcity)
image(matrix(1:100), col = lucky())
image(matrix(1:100), col = lucky())
image(matrix(1:100), col = lucky())
image(matrix(1:100), col = lucky())
image(matrix(1:100), col = lucky())
image(matrix(1:100), col = lucky(rev = TRUE))
image(matrix(1:100), col = lucky(nseed = 1))
}
}
