## ----knitr-setup, include = FALSE----------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup---------------------------------------------------------------
library(cqcr)

## ----care-homes, eval=FALSE----------------------------------------------
#  loc1 <- cqc_locations_search(care_home = TRUE,
#                               local_authority = c("Waltham Forest",
#                                                   "Hackney", "Tower Hamlets"))

## ----care-homes-data-frame, eval=FALSE-----------------------------------
#  care_home_list <- lapply(loc1$location_id, cqc_location)
#  
#  care_home_df <- map_dfr(care_home_list, `[`, c("location_id", "name", "number_of_beds",
#                                      "onspd_longitude", "onspd_latitude"))
#  
#  care_home_df <- care_home_df %>%
#    mutate(rating = care_home_list %>%
#             map(c("current_ratings", "overall", "rating")) %>% as.character(),
#           rating = recode(rating, "NULL" = "No published rating"),
#           rating = factor(rating, levels = c("Outstanding", "Good",
#                                              "Requires improvement",
#                                              "Inadequate",
#                                              "No published rating")),
#           report_date = care_home_list %>%
#             map(c("current_ratings", "reportDate")) %>%
#             as.character(),
#           report_date = ifelse(report_date == "NULL", NA, report_date) )
#  
#  care_home_df
#  

## ----care-home-local-creation, include=FALSE-----------------------------
library(purrr)
library(dplyr)
library(tibble)

care_home_df <- tibble(
  location_id = c("1-105426344", "1-105836127", "1-105885228", "1-106916349",
                  "1-107269593", "1-108969091", "1-109015718", "1-109949478",
                  "1-110213739", "1-1105339094", "1-110603520", "1-110603536",
                  "1-111337171", "1-112525446", "1-113193160", "1-114045387",
                  "1-114149881", "1-1142590749", "1-115313083", "1-115314138",
                  "1-115462840", "1-117269316", "1-117278932", "1-117286224",
                  "1-117294168", "1-117302022", "1-117302339", "1-117302367",
                  "1-117302381", "1-117309282", "1-118107409", "1-118111487",
                  "1-118115765", "1-118115794", "1-118127808", "1-118127822",
                  "1-118630360", "1-118630374", "1-118630388", "1-118636402",
                  "1-118636426", "1-118636440", "1-118682950", "1-118686044",
                  "1-118686061", "1-118686075", "1-118696189", "1-118696223",
                  "1-118696274", "1-118973223", "1-119185940", "1-119185954",
                  "1-119185968", "1-119185982", "1-119275343", "1-119324912",
                  "1-119702990", "1-119703055", "1-119748707", "1-119791836",
                  "1-119791854", "1-119915818", "1-119990111", "1-120285808",
                  "1-120285825", "1-120444769", "1-121430299", "1-121813669",
                  "1-121821992", "1-121822012", "1-122505743", "1-123622587",
                  "1-123622602", "1-124054556", "1-124054573", "1-124233252",
                  "1-124233294", "1-124583448", "1-124583530", "1-124583578",
                  "1-124583700", "1-124583750", "1-124583783", "1-124584209",
                  "1-125663307", "1-126102942", "1-126102957", "1-126160247",
                  "1-126160263", "1-126240959", "1-126242064", "1-126790225",
                  "1-128229903", "1-131623890", "1-131679959", "1-131707775",
                  "1-131707789", "1-1335175851", "1-135076061", "1-135286918",
                  "1-135968280", "1-136093185", "1-136277130", "1-136306528",
                  "1-136306548", "1-137389640", "1-137389654", "1-137389668",
                  "1-137389724", "1-138048814", "1-140398160", "1-140874721",
                  "1-140946428", "1-1428643301", "1-1428643334", "1-143127633",
                  "1-143603576", "1-145056589", "1-145218559", "1-145218595", 
                  "1-145218612", "1-145218629", "1-145218680", "1-145218731", 
                  "1-145547288", "1-147061769", "1-147061787", "1-149024982", 
                  "1-1512145311", "1-1523059481", "1-1523108665", 
                  "1-1568876761", "1-1568897413", "1-1568909453", 
                  "1-1568925336", "1-1575918167", "1-1738759982", 
                  "1-1738862264", "1-174209208", "1-1886382001", 
                  "1-192255171", "1-1979541744", "1-201502656", "1-201502671", 
                  "1-201502686", "1-2042053304", "1-2133804199", "1-215264629",
                  "1-2222935954", "1-222865586", "1-222865604", "1-222865619", 
                  "1-222865636", "1-222865656", "1-222865692", "1-222865713", 
                  "1-2891321183", "1-3078572279", "1-3096709704", 
                  "1-3096831098", "1-319143132", "1-319855383", "1-320351006",
                  "1-321490616", "1-328266861", "1-332700353", "1-333530468", 
                  "1-341648798", "1-344315543", "1-344316219", "1-394671147", 
                  "1-395069812", "1-4179610444", "1-4236476090", "1-432380794",
                  "1-432412053", "1-432412231", "1-432412357", "1-455848011",
                  "1-504382027", "1-504406809", "1-5101202892", "1-5182532935",
                  "1-5742368191", "1-6093241189", "1-6165857827", 
                  "1-6438056215", "1-745411917", "1-745672353", "1-745696264",
                  "1-785194640", "1-996710444", "RQX41"),
  name = c("Checaniah House", "Forest View Care Home", "Heathlands Care Home", 
           "Aspray House", "Acorn Lodge Care Centre", "St Michaels Lodge", 
           "Ashcroft Residential Home", "Rosemead Care Home", 
           "Albany Nursing Home", "Toby Lodge",
           "Ashbridge Lodge Residential Care Home",
           "Lakeside House Residential Care Home", 
           "Nonoy Capina - 31 Sach Road", "Ashville House", 
           "Forest Drive Residential Home", "Highams Lodge", 
           "Almadene Care Home (Goodcare Limited)", "St Catherine Rest Home",
           "Ashwood House Limited (Leyton)", "Abba Residential Home", 
           "Ebony House", "Springfield Care Home", "Highcroft Care Home", 
           "The Grove", "St Catherines Rest Home", "Alderbrook Care", 
           "Florfield Home", "Harold Lodge", "Haroldstone Home", 
           "Sable Care Limited - 22 Ashbridge Road", "Leyton Lodge", 
           "Edward House Care Home", "Bridge House", "Leyton House", 
           "Leyton House 2", "Esna House", "Church Lane", "Primrose Road", 
           "Drayton Road", "Queensdown Road", "Selwyn Road", "Buxton Street",
           "Prudential Care Home Limited", 
           "Norman Road (135)", "Ashleigh Rest Home", 
           "Mrs Rooksanah Jooma & Mr Yusuf Jooma - 136 Langthorne Road",
           "Prudential Care Home Limited No7", 
           "Prudential Care Home Limited No35", 
           "Prudential Care Home Limited No333", "Beis Pinchas", 
           "Vulcan Square", "Royal Mencap Society - 34-35 Huddleston Close",
           "Royal Mencap Society - 36 Huddleston Close",
           "Royal Mencap Society - 69-71 Old Ford Road", "Kestrel House",
           "Grove Road", "Carmen Lodge", "Lyncroft", 
           "Forest Lodge Residential Home", "22 Homer Road (Flats A & B)",
           "302 Wick Road (Flats 1 & 2)", 
           "Approach Lodge Limited - 2 Approach Road", "Queens Lodge",
           "Newnton House Residential Care Home", "Riverside House",
           "SENSE - 70 Castleton Road", "Essex House", "Salisbury Road",
           "St Ives Lodge Residential Care Home", 
           "Three Willows Residential Care Home", 
           "Care Support Services Limited - 11 Gloucester Drive", "Manor (The)",
           "Manor II", "Peter Shore Court", "Pat Shaw House", "The Bungalow",
           "Hilltop", "Outlook Care - Cann Hall Road", 
           "Outlook Care - Grove Road", "Outlook Care - Hainault Road", 
           "Outlook Care - Mornington Road", "Outlook Care - Summit Road",
           "Outlook Care - Waterside Lodge Recovery Centre", 
           "Westport Care Centre", "Forest Lodge", "Harbour Recovery Centre",
           "Greig House", "Peartree House Care Home", "Ross Wyld Care Home",
           "Anchor Homes - Monarch Court", "Silk Court Care Home",
           "Hartwood Lodge", "St Francis Residential Care Home",
           "St Anne's Home - London", "Homewards Limited - 51 Leonard Road",
           "Homewards Limited - 48 Leonard Road", 
           "Homewards Limited - 20 Leonard Road", "Lyncroft", 
           "Equinox - 126 Lower Clapton Road", "Aspen Court Nursing Home",
           "Hawthorn Green Residential and Nursing Home", "Nile Centre (The)", 
           "Median Road Care Home", "Yad Voezer 1", "Yad Voezer 2", 
           "Foulden Road", "Felstead Street", "Queensdown Road", 
           "Clarence Road", "Companion In Care Limited - Leyton", 
           "Parkview House", "Spinney (The)", "Aston Grange Care Home", 
           "Peter Shore Court", "Pat Shaw House", "Grove Residential Home",
           "Winray Care Housing", "Coxley House", 
           "Cascade 1 - Bergholt Crescent", "Cascade 3 - Linthorpe Road", 
           "Cascade 4 - Newick Road", "Cascade 5 - Ickburgh Road",
           "Cascade 8 - Brooke Road", "Cascade 11 - Alconbury Road", 
           "MIG House Residential Care Homes", 
           "Greenleaf House Residential Care Home", 
           "St Mary's Lodge Residential Care Home",
           "Ambleside Care Services Limited", "Normanshire Care Services Ltd",
           "Lakeside House Residential Care Home", 
           "Ashbridge Lodge Residential Care Home", 
           "Kadima Support UK Limited No 7a", "Kadima Support UK Limited No 7",
           "Kadima Support UK Limited No 35", "Kadima Support UK Limited No 333",
           "Carmen Lodge", "Connington Court", "Connington House", 
           "Hotel in the Park", "Gracewell of Chingford", 
           "ELMS in Waltham Forest", "Drayton Road", "93 Downs Park Road",
           "41B Evering Road", "Flat 1", "St Ives Lodge Residential Care Home",
           "Gracewell of Chingford",
           "Hillgreen Care Ltd - 6 Stoke Newington Common", "Kestrel House",
           "Alliston Road", "May Road", "George Mason Lodge", 
           "Trumpington Road", "Flaxen Road", "Mapleton Road", "Francis House",
           "Parkview House", "Salisbury Road", "Forward Support Limited", 
           "Forward Support Limited", "Aspen Court Nursing Home", 
           "Spinney (The)", "Forest Lodge", "Grosvenor Park Community Project",
           "Bayfield Court", "Maitland Lodge Residential Care Home",
           "Touchsky Care Home", "41b Evering Road", 
           "Flat 1, 219 Anthony Kendall House", "93 Downs Park Road", 
           "Manor 1", "Manor 2", "Outlook Care- The Bungalow", 
           "Three Willows Residential Care Home", "PIH London Ltd No7", 
           "PIH London Ltd No35", "PIH London Ltd No333", "PIH London Ltd No7a",
           "Toby Lodge", "BLAK Rock Ltd", "BLAK Rock Ltd", 
           "Beaumont Court Care Home", "Forest View Care Home", 
           "Approach Lodge", "Hotel in the Park", 
           "Hawthorn Green Residential and Nursing Home", "Bayis Shei Limited",
           "Jooma Care Homes Limited - 136 Langthorne Road", 
           "135 Norman Road", "Ashleigh Rest Home", "Forest Haven", 
           "St. Michaels Lodge", "Mary Seacole Nursing Home"),
  number_of_beds = c(3, 24, 84, 64, 98, 11, 15, 20, 61, 10, 5, 8, 5, 3, 19, 15,
                     16, 19, 17, 5, 8, 3, 23, 8, 19, 34, 4, 4, 5, 4, 5, 3, 13, 
                     15, 9, 5, 6, 6, 8, 7, 5, 5, 4, 3, 10, 5, 5, 6, 10, 44, 6, 
                     7, 3, 7, 19, 5, 11, 12, 9, 7, 8, 7, 16, 9, 9, 6, 3, 7, 35,
                     21, 8, 17, 17, 41, 40, 6, 6, 5, 5, 6, 6, 6, 16, 44, 12, 8,
                     20, 55, 54, 66, 51, 17, 29, 34, 3, 4, 3, 12, 20, 75, 90, 9,
                     37, 10, 8, 11, 24, 8, 15, 3, 53, 48, 45, 41, 38, 9, 4, 13, 
                     5, 5, 5, 5, 5, 6, 4, 6, 1, 9, 6, 8, 5, 4, 5, 6, 10, 11, 6, 
                     10, 7, 46, 3, 7, 4, 5, 4, 35, 46, 6, 19, 43, 22, 39, 15, 
                     24, 24, 32, 53, 6, 10, 5, 75, 48, 45, 5, 46, 14, 9, 2, 4, 
                     4, 16, 16, 6, 21, 5, 6, 10, 4, 10, 8, 5, 42, 24, 7, 7, 90, 
                     6, 5, 3, 9, 5, 10, 50),
  onspd_longitude = c(-0.04987, 0.001778, 0.002686, -0.016934, -0.053257, 
                      0.00205, 0.011968, -0.014135, -0.01872, -0.04012,
                      0.011972, 0.011968, -0.056399, 0.000858, 0.002254, 
                      0.000761, 0.000761, 0.007431, -0.014382, 0.005985,
                      0.001058, -0.015406, -0.014769, -0.014601, 0.007431, 
                      0.000257, -0.057047, 0.007354, 0.007354, 0.011972, 
                      -0.006667, -0.024832, -0.008362, -0.005416, -0.005416,
                      -0.022112, -0.009232, -0.01449, 0.003102, -0.057992, 
                      -0.033307, -0.064864, -0.066455, 0.004787, 0.001778, 
                      0.00032, -0.066455, -0.0598, -0.090163, -0.086515, 
                      -0.021576, -0.054954, -0.054954, -0.049986, 0.007328,
                      -0.03545, 0.0176, 0.0176, 0.016731, -0.034884, -0.034088,
                      -0.051787, 0.005321, -0.085285, -0.090163, 0.002359, 
                      -0.004461, -0.003955, 0.006392, -0.002436, -0.098408,
                      -0.000931, 0.003165, -0.044998, -0.047121, -0.003274,
                      -0.013647, 0.007215, -0.014601, 0.003165, 0.013279,
                      -0.010127, 0.000645, -0.043423, 0.003373, -0.025646, 
                      -0.025646, 0.012981, -0.01955, -0.029968, -0.064258, 
                      0.0176, 0.007803, -0.079689, -0.019345, -0.019345,
                      -0.019345, 0.0176, -0.053324, -0.026495, -0.047646,
                      -0.0692, -0.050696, -0.088067, -0.08801, -0.0692,
                      -0.027885, -0.057992, -0.055859, 0.007144, -0.017224, 
                      0.004131, -0.01955, -0.044998, -0.047121, -0.01097, 
                      0.001986, -0.026077, -0.080506, -0.075572, -0.053357,
                      -0.059213, -0.066998, -0.064738, 0.001428, -0.022226,
                      -0.017124, -0.01602, -0.010125, 0.011968, 0.011972, 
                      -0.066455, -0.066455, -0.0598, -0.090163, 0.0176, 
                      0.007506, 0.007506, -0.05131, 0.003962, 0.002685,
                      0.003102, -0.056684, -0.070793, -0.056441, 0.006392, 
                      0.003962, -0.069524, 0.007328, -0.009868, -0.02136, 
                      0.00466, 0.015882, -0.008362, -0.003581, -0.025052, 
                      -0.017224, -0.003955, -0.090163, -0.066455, -0.026495,
                      0.004131, 0.003373, -0.016077, 0.003962, -0.05519,
                      0.015683, -0.070793, -0.056441, -0.056684, -0.000931,
                      0.003165, -0.003274, -0.002436, -0.066455, -0.0598,
                      -0.090163, -0.066455, -0.04012, 0.011968, 0.011972,
                      -0.044998, 0.001778, -0.051787, -0.05131, -0.047646, 
                      -0.080081, 0.00032, 0.004787, 0.001778, -0.006361,
                      0.00205, -0.077786),
    onspd_latitude = c(51.557614, 51.587829, 51.618649, 51.573186, 51.554943,
                       51.568724, 51.573726, 51.586724, 51.57325, 51.517272,
                       51.572853, 51.573726, 51.564529, 51.562621, 51.574018,
                       51.609754, 51.609754, 51.552967, 51.563509, 51.555843,
                       51.574056, 51.578769, 51.587094, 51.578692, 51.552967, 51.601848,
                       51.544539, 51.565648, 51.565648, 51.572853, 51.557488,
                       51.58739, 51.577795, 51.554124, 51.554124, 51.564251,
                       51.584959, 51.566688, 51.567385, 51.554167, 51.530178, 51.521746,
                       51.573326, 51.563381, 51.587829, 51.55596, 51.573326,
                       51.560834, 51.573031, 51.566434, 51.489154, 51.531726,
                       51.531726, 51.530906, 51.565046, 51.526284, 51.569249,
                       51.569249, 51.567927, 51.544448, 51.544831, 51.531268, 51.569928,
                       51.573734, 51.573031, 51.59415, 51.577216, 51.561455,
                       51.63428, 51.633583, 51.566349, 51.570178, 51.573085,
                       51.520454, 51.523044, 51.612195, 51.588316, 51.553313, 51.578692,
                       51.573085, 51.565844, 51.583634, 51.556105, 51.514151,
                       51.589674, 51.508638, 51.508638, 51.632232, 51.59034,
                       51.543395, 51.527878, 51.569249, 51.609542, 51.566808, 51.608987,
                       51.608987, 51.608987, 51.569249, 51.553712, 51.51404,
                       51.518871, 51.556232, 51.55144, 51.566253, 51.567259,
                       51.556232, 51.544547, 51.554167, 51.554465, 51.552343, 51.613907,
                       51.636349, 51.59034, 51.520454, 51.523044, 51.579197,
                       51.569229, 51.526675, 51.573782, 51.572046, 51.556986,
                       51.560734, 51.560863, 51.562102, 51.569347, 51.587553, 51.580408,
                       51.569958, 51.617042, 51.573726, 51.572853, 51.573326,
                       51.573326, 51.560834, 51.573031, 51.569249, 51.6199,
                       51.6199, 51.533994, 51.618476, 51.56741, 51.567385, 51.553049,
                       51.557796, 51.557055, 51.63428, 51.618476, 51.561516,
                       51.565046, 51.586589, 51.609221, 51.568032, 51.555862,
                       51.620348, 51.619026, 51.574033, 51.613907, 51.561455, 51.573031,
                       51.573326, 51.51404, 51.636349, 51.589674, 51.579628,
                       51.618476, 51.553573, 51.554633, 51.557796, 51.557055,
                       51.553049, 51.570178, 51.573085, 51.612195, 51.633583, 51.573326,
                       51.560834, 51.573031, 51.573326, 51.517272, 51.573726,
                       51.572853, 51.520454, 51.587829, 51.531268, 51.533994,
                       51.518871, 51.568119, 51.55596, 51.563381, 51.587829, 51.634101,
                       51.568724, 51.533919),
            rating = c("No published rating", "Good", "Good",
                       "Requires improvement", "Requires improvement",
                       "No published rating", "No published rating",
                       "No published rating", "Good", "Good", "No published rating",
                       "No published rating", "Good", "Good", "Requires improvement", "Good",
                       "Requires improvement", "Good", "Good", "Good",
                       "Requires improvement", "No published rating", "Good", "Outstanding",
                       "No published rating", "No published rating", "Good",
                       "Good", "Good", "Good", "Good", "Good", "Good",
                       "Requires improvement", "No published rating", "Good", "Inadequate",
                       "Good", "Good", "No published rating", "No published rating",
                       "No published rating", "No published rating",
                       "No published rating", "No published rating", "No published rating",
                       "No published rating", "No published rating",
                       "No published rating", "Good", "No published rating", "Good", "Good",
                       "No published rating", "No published rating",
                       "No published rating", "No published rating", "No published rating",
                       "No published rating", "No published rating",
                       "No published rating", "Good", "No published rating", "Good", "Good",
                       "Good", "No published rating", "Requires improvement",
                       "No published rating", "Good", "No published rating",
                       "No published rating", "No published rating",
                       "No published rating", "No published rating",
                       "Good", "No published rating",
                       "No published rating", "No published rating",
                       "No published rating", "No published rating", "Good", "Good", "Good",
                       "No published rating", "No published rating",
                       "No published rating", "Requires improvement", "Requires improvement",
                       "No published rating", "Outstanding",
                       "No published rating", "Requires improvement",
                       "Requires improvement", "Good",
                       "Good", "Good", "Good", "No published rating",
                       "No published rating", "Requires improvement", "No published rating",
                       "Good", "Good", "Requires improvement", "Good", "Good",
                       "Good", "Good", "No published rating", "Good",
                       "No published rating", "Inadequate", "Requires improvement",
                       "Requires improvement", "Good", "No published rating", "Good",
                       "No published rating", "No published rating", "Inadequate",
                       "No published rating", "No published rating",
                       "No published rating", "Good", "No published rating",
                       "No published rating", "No published rating", "Good", "Good", "Good",
                       "Requires improvement", "Good", "Good", "Good", "Good", "Good",
                       "Good", "Good", "Good", "Requires improvement", "Good",
                       "No published rating", "No published rating",
                       "No published rating", "Good", "Good", "Inadequate", "Good", "Good",
                       "No published rating", "Good", "Good", "No published rating",
                       "Requires improvement", "No published rating", "Good",
                       "Good", "Good", "Good", "Requires improvement", "Good",
                       "No published rating", "Good", "No published rating",
                       "No published rating", "Good", "No published rating",
                       "No published rating", "No published rating", "Good",
                       "No published rating", "Good", "Good", "No published rating",
                       "No published rating", "No published rating", "No published rating",
                       "No published rating", "No published rating",
                       "No published rating", "Requires improvement", "Good", "Good", "Good",
                       "No published rating", "No published rating", "Good",
                       "Good", "No published rating", "Good", "Good", "Good"),
       report_date = c(NA, "2016-01-19", "2018-09-12", "2019-03-23",
                       "2018-09-15", NA, NA, NA, "2017-10-27", "2018-03-21",
                       NA, NA, "2017-06-30", "2018-08-29", "2015-07-20",
                       "2018-10-13", "2017-03-03", "2018-05-05", "2017-09-23",
                       "2017-06-24", "2019-06-04", NA, "2017-09-19", "2018-08-01", NA, NA,
                       "2017-10-04", "2017-06-21", "2018-02-23", "2017-03-24",
                       "2018-10-25", "2017-08-15", "2016-05-04", "2018-10-06", NA,
                       "2019-05-01", "2015-03-30", "2017-02-25", "2015-03-25", NA,
                       NA, NA, NA, NA, NA, NA, NA, NA, NA, "2019-06-04", NA,
                       "2017-12-05", "2018-04-27", NA, NA, NA, NA, NA, NA, NA, NA,
                       "2017-11-29", NA, "2018-07-19", "2017-05-26", "2018-08-24",
                       NA, "2016-10-20", NA, "2016-04-07", NA, NA, NA, NA, NA,
                       "2017-05-16", NA, NA, NA, NA, NA, "2018-05-12",
                       "2017-06-14", "2018-12-15", NA, NA, NA, "2016-09-20", "2018-02-09",
                       NA, "2017-09-12", NA, "2019-01-01", "2018-11-17",
                       "2018-11-09", "2018-08-09", "2017-10-31", "2019-05-18", NA, NA,
                       "2019-02-21", NA, "2015-04-13", "2018-01-31", "2018-11-21",
                       "2016-05-06", "2018-02-28", "2016-04-02", "2017-06-03", NA,
                       "2016-10-07", NA, "2017-02-10", "2017-02-28",
                       "2017-10-31", "2019-05-22", NA, "2017-04-19", NA, NA, "2015-05-27",
                       NA, NA, NA, "2017-10-25", NA, NA, NA, "2018-01-05",
                       "2019-03-02", "2017-11-01", "2015-10-19", "2016-08-13",
                       "2015-06-01", "2015-12-22", "2017-11-10", "2016-12-24",
                       "2017-01-12", "2018-07-21", "2019-01-31", "2018-03-28", "2018-08-04",
                       NA, NA, NA, "2017-12-16", "2019-02-01", "2017-10-28",
                       "2019-01-12", "2017-06-21", NA, "2017-10-05", "2017-10-05",
                       NA, "2019-08-15", NA, "2018-03-17", "2018-02-28",
                       "2018-06-29", "2017-11-22", "2018-12-15", "2018-03-20", NA,
                       "2018-08-03", NA, NA, "2017-02-15", NA, NA, NA, "2016-07-13", NA,
                       "2018-10-03", "2018-10-18", NA, NA, NA, NA, NA, NA, NA,
                       "2018-12-05", "2019-02-09", "2019-08-13", "2019-05-02", NA,
                       NA, "2017-05-16", "2017-07-11", NA, "2018-06-30",
                       "2017-03-15", "2017-08-25")
)

care_home_df <- care_home_df %>%
  mutate(rating = factor(rating, levels = c("Outstanding", "Good",
                                            "Requires improvement", 
                                            "Inadequate",
                                            "No published rating")))

care_home_df

## ----leaflet-map---------------------------------------------------------
library(leaflet)

pal <- colorFactor(c("blue", "green", "orange", "red", "gray27"),
                   domain = care_home_df$rating)

labels <- paste0(
  "<strong>Name:</strong> ", care_home_df$name,"</br>",
  "<strong>Number of Beds:</strong> ", care_home_df$number_of_beds, "</br>",
  "<strong>Rating:</strong> ", care_home_df$rating, "</br>",
  "<strong>Report Date:</strong> ", format(as.Date(care_home_df$report_date), "%e %B %Y")
) %>% lapply(htmltools::HTML)

map <- leaflet(care_home_df) %>%
  addTiles() %>%
    addCircleMarkers(lng = ~onspd_longitude,
             lat = ~onspd_latitude,
             label = labels,
             color = ~pal(rating), 
             radius = ~scales::rescale(care_home_df$number_of_beds, to = c(5, 15)))


map

