% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{as.igraph.cranly_network}
\alias{as.igraph.cranly_network}
\title{Coerce a \code{\link{cranly_network}} to an \code{\link[igraph]{graph}} object}
\usage{
\method{as.igraph}{cranly_network}(x, reverse = FALSE, ...)
}
\arguments{
\item{x}{a \code{\link{cranly_network}} object}

\item{reverse}{logical. Should the direction of the edges be reversed? See details. Default is \code{TRUE}}

\item{...}{currently not used}
}
\description{
Coerce a \code{\link{cranly_network}} to an \code{\link[igraph]{graph}} object
}
\details{
The convention for a \code{\link{cranly_network}} object with
\code{perspective = "package"} is that the direction of an edge is
from the package that is imported by, suggested by, enhances or is
a dependency of another package, to the latter
package. \code{reverse} reverses that direction to correctly
compute relevant network summaries (see
\code{summary.cranly_network}). \code{reverse} is only relevant
when the \code{attr(x, "perspective")} is "package" and is ignored
when \code{attr(x, "perspective")} is "author", in which case the
resulting \code{\link[igraph]{graph}} object represents an
undirected network of authors.
}
\examples{
\dontrun{

#' cran_db <- clean_CRAN_db()
## Package directives network
package_network <- build_network(object = cran_db, perspective = "package")
igraph::as.igraph(package_network)

## Author collaboration network
author_network <- build_network(object = cran_db, perspective = "author")
igraph::as.igraph(author_network)

}
}
