% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{conf_int_search}
\alias{conf_int_search}
\title{Randomisation test confidence interval limit search}
\usage{
conf_int_search(
  fitlist,
  data,
  actual_tr,
  start,
  nsteps = 1000,
  alpha = 0.025,
  plots = TRUE,
  cl_var = "cl",
  rand_func = NULL,
  verbose = TRUE
)
}
\arguments{
\item{fitlist}{A list of p fitted mer class model objects}

\item{data}{A data frame used to fit the models in fitlist}

\item{actual_tr}{A vector of length p with the original point estimates of the
treatment effects}

\item{start}{A vector of length p with a set of starting values for the search. The uncorrected
confidence set limits (tr_eff +/- 2*SE) usually provide a good starting point.}

\item{nsteps}{Number of steps for the search process.}

\item{alpha}{Numeric value. The process searches for the 100(1-2*alpha) confidence intervals}

\item{plots}{Logical value indicating whether to plot the search process. Default to TRUE}

\item{cl_var}{String indicating the name of the column in data with the IDs of the clusters}

\item{rand_func}{The name of a function that re-randomises the clusters. The function should
produce a data frame that identifies the clusters in the treatment group under the new
randomisation scheme. The data frame can either have a single column with name cl_var or
two columns of cl_var and t identifying the cluster ID and time period a cluster joins
the treatment group.  If NULL then clusters are randomised in a 1:1 ratio to treatment and control}

\item{verbose}{Logical indicating whether to provide verbose output showing progress and estimates}
}
\value{
A vector of length p with the estimates of the limits
}
\description{
A multi-variate Robbins-Monroe search process to estimate the upper of lower
limits for a confidence set for parameters from a list of fitted model objects.
}
\details{
A version of the search process proposed by Garthwaite (1996) adapted for multiple
limits. Given a set of estimates of the upper or lower, the process calculates the test
statistics for the two-sided null hypotheses that the treatment effects equal these values,
and then conducts a single iteration randomisation test of the same null hypotheses. The
estimates are then updated based on whether the actual test statistic is higher or lower
than the randomisation test statistic it would be compared to under the resampling stepdown
approach of Romano & Wolf (2005). At the limits of the confidence set all values should
be rejected in a two-sided hypothesis test with a family-wise error rate of alpha, which
provides a probabilistic basis for the search process. See Watson (2021) for more details.
}
\examples{
out <- twoarm_sim()
data <- out[[1]]
fit1 <- lme4::glmer(y1 ~ treat + (1|cl) ,
                    data=data,
                    family="poisson")

fit2 <- lme4::glmer(y2 ~ treat + (1|cl),
                    data=data,
                    family="poisson")
fitlist <- list(fit1,fit2)
tr_eff <- rep(NA,2)
for(i in 1:2){
    res <- summary(fitlist[[i]])
    tr_eff[i] <- res$coefficients["treat",'Estimate']
}
conf_int_search(fitlist,
                 data = data,
                 actual_tr=tr_eff,
                 start=tr_eff+1,
                 nsteps=100,
                 alpha=0.025,
                 plots = FALSE,
                 cl_var = "cl",
                 verbose = FALSE)
}
