% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ctree_rules.R
\name{get_ctree_rules}
\alias{get_ctree_rules}
\title{Parse party ctree rules}
\usage{
get_ctree_rules(tree_fit = NULL, train_dat = NULL, target = NULL,
  test_dat = NULL, tree_control = list(p = 0.05, cp = 0.0001, xval = 1,
  maxdepth = 10), seed = 46)
}
\arguments{
\item{tree_fit}{A tree model object.}

\item{train_dat}{A data.frame of train.}

\item{target}{The name of target variable.}

\item{test_dat}{A data.frame of test.}

\item{tree_control}{the list of parameters to control cutting initial breaks by decision tree.}

\item{seed}{Random number seed. Default is 46.}
}
\value{
A data frame with tree rules and bad percent under each rule.
}
\description{
\code{get_ctree_rules} This function is used to parse party ctree rules and percentage of bad under each rule.
}
\examples{
train_test <- train_test_split(UCICreditCard, split_type = "Random", prop = 0.8, save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
dat_train$default.payment.next.month = as.numeric(dat_train$default.payment.next.month)
get_ctree_rules(tree_fit = NULL, train_dat = dat_train[, 8:26],
target ="default.payment.next.month", test_dat = dat_test)

}
