% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_binning.R
\name{select_best_class}
\alias{select_best_class}
\alias{select_best_breaks}
\title{Generates Best Binning Breaks}
\usage{
select_best_class(
  dat,
  x,
  target,
  breaks = NULL,
  occur_time = NULL,
  oot_pct = 0.7,
  pos_flag = NULL,
  bins_control = NULL,
  sp_values = NULL,
  ...
)

select_best_breaks(
  dat,
  x,
  target,
  breaks = NULL,
  pos_flag = NULL,
  sp_values = NULL,
  occur_time = NULL,
  oot_pct = 0.7,
  bins_control = NULL,
  ...
)
}
\arguments{
\item{dat}{A data frame with x and target.}

\item{x}{The name of variable to process.}

\item{target}{The name of target variable.}

\item{breaks}{Splitting points for an independent variable. Default is NULL.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.}

\item{oot_pct}{The percentage of Actual and Expected set for PSI calculating.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{bins_control}{the list of parameters.
\itemize{
  \item \code{bins_num} The maximum number of bins. 5 to 10 usually work. Default: 10
  \item \code{bins_pct} The minimum percent of observations in any bins. 0 < bins_pct < 1 , 0.01 to 0.1 usually work. Default: 0.02.
  \item \code{b_chi} The minimum threshold of chi-square merge. 0 < b_chi< 1; 0.01 to 0.1 usually work. Default: 0.02.
  \item \code{b_odds} The minimum threshold of  odds merge. 0 < b_odds < 1; 0.05 to 0.2 usually work. Default: 0.1.
  \item \code{b_psi} The maximum threshold of PSI in any bins. 0 < b_psi < 1 ; 0 to 0.1 usually work. Default: 0.05.
  \item \code{b_or} The maximum threshold of G/B index in any bins.  0 < b_or < 1 ; 0.05 to 0.3 usually work. Default: 0.15.
  \item \code{odds_psi} The maximum threshold of Training and Testing G/B index PSI in any bins. 0 < odds_psi < 1 ; 0.01 to 0.3 usually work. Default: 0.1.
  \item \code{mono} Monotonicity of all bins, the larger, the more nonmonotonic the bins will be.  0 < mono < 0.5 ; 0.2 to 0.4 usually work. Default: 0.2.
  \item \code{kc} number of cross-validations. 1 to 5 usually work. Default: 1.
}}

\item{sp_values}{A list of special value.}

\item{...}{Other parameters.}
}
\value{
A list of breaks for x.
}
\description{
\code{select_best_class} & \code{select_best_breaks} are  for merging initial breaks of variables using chi-square, odds-ratio,PSI,G/B index and so on.
The \code{get_breaks}  is a simpler wrapper for \code{select_best_class} & \code{select_best_class}.
}
\details{
The folloiwing is the list of Reference Principles
\itemize{
     \item 1.The increasing or decreasing trend of variables is consistent with the actual business experience.(The percent of Non-monotonic intervals of which are not head or tail is less than 0.35)
     \item 2.Maximum 10 intervals for a single variable.
     \item 3.Each interval should cover more than 2% of the model development samples.
     \item 4.Each interval needs at least 30 or 1% positive samples. .
     \item 5.Combining the values of blank, missing or other special value into the same interval called missing.
     \item 6.The difference of Chi effect size between intervals should be at least 0.02 or more.
     \item 7.The difference of absolute odds ratio between intervals should be at least 0.1 or more.
     \item 8.The difference of positive rate between intervals should be at least 1/10 of the total positive rate.
     \item 9.The difference of G/B index between intervals should be at least 15 or more.
     \item 10.The PSI of each interval should be less than 0.1.
  }
}
\examples{
#equal sample size breaks
equ_breaks = cut_equal(dat = UCICreditCard[, "PAY_AMT2"], g = 10)

# select best bins
bins_control = list(bins_num = 10, bins_pct = 0.02, b_chi = 0.02,
b_odds = 0.1, b_psi = 0.05, b_or = 0.15, mono = 0.3, odds_psi = 0.1, kc = 1)
select_best_breaks(dat = UCICreditCard, x = "PAY_AMT2", breaks = equ_breaks,
target = "default.payment.next.month", occur_time = "apply_date",
sp_values = NULL, bins_control = bins_control)
}
\seealso{
\code{\link{get_tree_breaks}},
\code{\link{cut_equal}},
\code{\link{get_breaks}}
}
