% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add_dates.R
\name{add_dates}
\alias{add_dates}
\title{Return CDS dates.}
\usage{
add_dates(x, date.var = "date", maturity.var = "maturity",
  tenor.var = "tenor", currency.var = "currency")
}
\arguments{
\item{x}{a data frame, containing all necessary information}

\item{date.var}{character, column name of date variable}

\item{maturity.var}{character, column name of maturity variable}

\item{tenor.var}{character, column name of tenor variable}

\item{currency.var}{character, column name of currency variable}
}
\value{
a date frame containing all the input columns, as well as eight more
  columns: stepinDate (T+1), valueDate (T+3 business days), startDate
  (accrual begin date), endDate (maturity), backstopDate (T-60 day look back
  from which 'protection' is effective), firstcouponDate (the date on which
  the first coupon is paid), pencouponDate (second to last coupon date), and
  baseDate (the starting date for the IR curve)
}
\description{
\code{add_dates} takes a data frame which contains dates, tenor (or maturity)
and currency and returns appropriate dates for pricing a CDS contract.
}
\examples{
x <- data.frame(date = c(as.Date("2014-05-06"), as.Date("2014-05-07")),
                tenor = rep(5, 2), currency = c("JPY", "USD"))
add_dates(x)
}
\references{
\url{http://www.cdsmodel.com/cdsmodel/assets/cds-model/docs/c-code%20Key%20Functions-v1.pdf
}
\url{http://www.cdsmodel.com/assets/cds-model/docs/Standard%20CDS%20Examples.pdf
}
}

