% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cj_freqs.R, R/cj_props.R, R/cj_table.R
\name{cj_freqs}
\alias{cj_freqs}
\alias{cj_props}
\alias{cj_table}
\title{Conjoint feature frequencies}
\usage{
cj_freqs(data, formula, id = NULL, weights = NULL, feature_order = NULL,
  feature_labels = NULL, level_order = c("ascending", "descending"), ...)

cj_props(data, formula, id, weights = NULL, margin = NULL, ...)

cj_table(data, formula, feature_order = NULL, feature_labels = NULL,
  level_order = c("ascending", "descending"), include_reference = FALSE,
  ...)
}
\arguments{
\item{data}{A data frame containing variables specified in \code{formula}. All RHS variables should be factors.}

\item{formula}{An RHS formula specifying conjoint features to tabulate. All RHS variables should be factors.}

\item{id}{An RHS formula specifying a variable holding respondent identifiers, to be used for clustering standard errors.}

\item{weights}{An (optional) RHS formula specifying a variable holding survey weights.}

\item{feature_order}{An (optional) character vector specifying the names of feature (RHS) variables in the order they should be encoded in the resulting data frame.}

\item{feature_labels}{A named list of \dQuote{fancy} feature labels to be used in output. By default, the function looks for a \dQuote{label} attribute on each variable in \code{formula} and uses that for pretty printing. This argument overrides those attributes or otherwise provides fancy labels for this purpose. This should be a list with names equal to variables on the righthand side of \code{formula} and character string values; arguments passed here override variable attributes.}

\item{level_order}{A character string specifying levels (within each feature) should be ordered increasing or decreasing in the final output. This is mostly only consequential for plotting via \code{\link{plot.cj_mm}}, etc.}

\item{\dots}{Ignored.}

\item{margin}{A numeric value passed to \code{\link[base]{prop.table}}. If \code{NULL} overall proportions are calculated.}

\item{include_reference}{A logical indicating whether to include a \dQuote{reference} column that indicates whether a feature level is the reference category for that feature. Default is \code{FALSE}.}
}
\description{
Tabulate and visualize conjoint features, and their display frequencies and proportions
}
\details{
These functions provide related but slightly different functionality. \code{cj_table} simply creates a data frame of features and their levels, which is useful for printing. \code{cj_props} provides tidy proportion tables to examine cross-feature restrictions in conjoint designs that are not equally randomized. This enables, for example, tabulation and visualization of complete restrictions (where combinations of two or more features are not permitted), as well as calculation of AMCEs for constrained designs appropriately weighted by the display proportions for particular combinations of features.

\code{cj_freqs} provides \emph{marginal} display frequencies, which are a descriptive check on the presentation of individual conjoint features (for example, to ensure equal or intentionally unequal appearance of levels). This is mostly useful for plotting functionality provided in \code{\link{plot.cj_freqs}}, which provides barcharts for the frequency with which each level of each feature was presented.
}
\examples{
data(immigration)
# identify all levels
cj_table(immigration, ~ Gender + Education + LanguageSkills)
cj_table(immigration, ~ Gender + Education + LanguageSkills, include_ref = TRUE)

# display frequencies
cj_freqs(immigration, ~ Gender + Education + LanguageSkills, id = ~ CaseID)

# restrictions
## check display proportions
cj_props(immigration, ~ Job, id = ~ CaseID)
## check which combinations were not allowed
subset(cj_props(immigration, ~ Job + Education, id = ~ CaseID), Proportion == 0)

}
\seealso{
\code{\link{plot.cj_mm}}
}
