% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_callr.R
\name{crew_class_launcher_callr}
\alias{crew_class_launcher_callr}
\title{\code{mirai} launcher class}
\description{
\code{R6} class to launch and manage \code{mirai} workers.
}
\details{
See \code{\link[=crew_launcher_callr]{crew_launcher_callr()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$listen()
launcher <- crew_launcher_callr()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result")
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}
}
\seealso{
Other launchers: 
\code{\link{crew_class_launcher}},
\code{\link{crew_launcher_callr}()},
\code{\link{crew_launcher}()}
}
\concept{launchers}
\section{Super class}{
\code{\link[crew:crew_class_launcher]{crew::crew_class_launcher}} -> \code{crew_class_launcher_callr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher_callr-launch_worker}{\code{crew_class_launcher_callr$launch_worker()}}
\item \href{#method-crew_class_launcher_callr-terminate_worker}{\code{crew_class_launcher_callr$terminate_worker()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="active"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-active'><code>crew::crew_class_launcher$active()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="initialize"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-initialize'><code>crew::crew_class_launcher$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launch"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launch'><code>crew::crew_class_launcher$launch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="populate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-populate'><code>crew::crew_class_launcher$populate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="settings"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-settings'><code>crew::crew_class_launcher$settings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="terminate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-terminate'><code>crew::crew_class_launcher$terminate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="validate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-validate'><code>crew::crew_class_launcher$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_callr-launch_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_callr-launch_worker}{}}}
\subsection{Method \code{launch_worker()}}{
Launch a \code{callr} worker to dial into a socket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_callr$launch_worker(socket, host, port, token, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{socket}}{Socket where the worker will receive tasks.}

\item{\code{host}}{IP address of the \code{mirai} client that sends tasks.}

\item{\code{port}}{TCP port to register a successful connection
to the host. Different from that of \code{socket}.}

\item{\code{token}}{Character of length 1 to identify the instance
of the \code{mirai} server process connected to the socket.}

\item{\code{name}}{User-supplied name of the launcher, useful for
constructing informative job labels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{callr::r_bg()} handle.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_callr-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_callr-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Terminate a \code{callr} worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_callr$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A \code{callr} process handle previously
returned by \code{launch_worker()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
