% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_callr.R
\name{crew_launcher_callr}
\alias{crew_launcher_callr}
\title{Create a launcher with \code{callr} workers.}
\usage{
crew_launcher_callr(
  name = NULL,
  seconds_launch = 30,
  seconds_interval = 0.001,
  seconds_timeout = 10,
  seconds_idle = Inf,
  seconds_wall = Inf,
  seconds_exit = 0.1,
  tasks_max = Inf,
  tasks_timers = 0L,
  async_dial = TRUE,
  cleanup = FALSE
)
}
\arguments{
\item{name}{Name of the launcher.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::server()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::server()}.}

\item{seconds_exit}{Number of seconds to wait for NNG websockets
to finish sending large data (in case an exit signal is received).
See the \code{exitlinger} argument of \code{mirai::server()}.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::server()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerlaunch} argument of \code{mirai::server()}.}

\item{async_dial}{Logical, whether the \code{mirai} workers should dial in
asynchronously. See the \code{asyncdial} argument of \code{mirai::server()}.}

\item{cleanup}{Logical, whether to clean up global options and the
global environment after every task.
See the \code{cleanup} argument of \code{mirai::server()}.}
}
\description{
Create an \code{R6} object to launch and maintain
\code{callr} workers for a controller.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$listen()
launcher <- crew_launcher_callr()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result")
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}
}
\seealso{
Other launchers: 
\code{\link{crew_class_launcher_callr}},
\code{\link{crew_class_launcher}},
\code{\link{crew_launcher}()}
}
\concept{launchers}
