% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller.R
\name{crew_controller}
\alias{crew_controller}
\title{Create a controller.}
\usage{
crew_controller(router, launcher, auto_scale = NULL)
}
\arguments{
\item{router}{An \code{R6} router object created by \code{\link[=crew_router]{crew_router()}}.}

\item{launcher}{An \code{R6} launcher object created by one of the
\verb{crew_launcher_*()} functions such as \code{\link[=crew_launcher_local]{crew_launcher_local()}}.}

\item{auto_scale}{Deprecated. Use the \code{scale} argument of \code{push()},
\code{pop()}, and \code{wait()} instead.}
}
\description{
Create an \code{R6} object to submit tasks and launch workers.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
router <- crew_router()
launcher <- crew_launcher_local()
controller <- crew_controller(router = router, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\seealso{
Other controllers: 
\code{\link{crew_class_controller_group}},
\code{\link{crew_class_controller}},
\code{\link{crew_controller_group}()},
\code{\link{crew_controller_local}()}
}
\concept{controllers}
\keyword{internal}
