% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_assert.R
\name{crew_deprecate}
\alias{crew_deprecate}
\title{Deprecate a \code{crew} feature.}
\usage{
crew_deprecate(
  name,
  date,
  version,
  alternative,
  condition = "warning",
  value = "x",
  skip_cran = FALSE,
  frequency = "always"
)
}
\arguments{
\item{name}{Name of the feature (function or argument) to deprecate.}

\item{date}{Date of deprecation.}

\item{version}{Package version when deprecation was instated.}

\item{alternative}{Message about an alternative.}

\item{condition}{Either "warning" or "message" to indicate the type
of condition thrown on deprecation.}

\item{value}{Value of the object. Deprecation is skipped
if \code{value} is \code{NULL}.}

\item{skip_cran}{Logical of length 1, whether to skip the deprecation
warning or message on CRAN.}

\item{frequency}{Character of length 1, passed to the \code{.frequency}
argument of \code{rlang::warn()}.}
}
\value{
\code{NULL} (invisibly). Throws a warning if a feature is deprecated.
}
\description{
Show an informative warning when a \code{crew} feature is
deprecated.
}
\examples{
suppressWarnings(
  crew_deprecate(
    name = "auto_scale",
    date = "2023-05-18",
    version = "0.2.0",
    alternative = "use the scale argument of push(), pop(), and wait()."
  )
)
}
\seealso{
Other utility: 
\code{\link{crew_assert}()},
\code{\link{crew_clean}()},
\code{\link{crew_eval}()},
\code{\link{crew_random_name}()},
\code{\link{crew_retry}()},
\code{\link{crew_worker}()}
}
\concept{utility}
