% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criticalpath_methodsAOE.R
\name{solve_pathAOA}
\alias{solve_pathAOA}
\title{Finds a solution using CPM and PERT methods}
\usage{
solve_pathAOA(input_data, deterministic = TRUE)
}
\arguments{
\item{input_data}{Data frame containing the structure of the graph and the duration of the activity.
For the CPM method there will be 4 columns (the order is important, not the name of the column):
\enumerate{
\item \code{from} The number of the node where the activity starts.
\item \code{to} The number of the node where the activity ends.
\item \code{label} Activity labels.
\item \code{time} Activities duration.
}
For the PERT method there will be 4 columns (the order is important, not the name of the column):
\enumerate{
\item \code{from} The number of the node where the activity starts.
\item \code{to} The number of the node where the activity ends.
\item \code{label} Activity labels.
\item \code{opt_time} Optimistic duration of activities.
\item \code{likely_time} The most likely duration of the activity.
\item \code{pes_time} Pessimistic duration of activities.
}}

\item{deterministic}{A logical parameter specifying the solution method.
If set to \code{TRUE} (default), the CPM method is used. If is set to \code{FALSE}, the PERT method is used.}
}
\value{
The list is made of a graph, schedule and selected partial results.
}
\description{
Finds a solution using CPM and PERT methods
}
\examples{
x <- solve_pathAOA(cpmexample1, deterministic = TRUE)
y <- solve_pathAOA(pertexample1, deterministic = FALSE)
}
