% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Model-methods.R
\docType{methods}
\name{gain}
\alias{gain}
\alias{gain,numeric,ModelTox,Samples,EffFlexi,Samples-method}
\alias{gain,numeric,ModelTox,Samples,Effloglog,Samples-method}
\alias{gain,numeric,ModelTox,missing,Effloglog,missing-method}
\title{Compute the gain value with a given dose level, given a pseudo DLE model, a DLE sample,
a pseudo Efficacy log-log model and a Efficacy sample}
\usage{
gain(dose, DLEmodel, DLEsamples, Effmodel, Effsamples, ...)

\S4method{gain}{numeric,ModelTox,Samples,Effloglog,Samples}(dose, DLEmodel,
  DLEsamples, Effmodel, Effsamples, ...)

\S4method{gain}{numeric,ModelTox,Samples,EffFlexi,Samples}(dose, DLEmodel,
  DLEsamples, Effmodel, Effsamples, ...)

\S4method{gain}{numeric,ModelTox,missing,Effloglog,missing}(dose, DLEmodel,
  DLEsamples, Effmodel, Effsamples, ...)
}
\arguments{
\item{dose}{the dose}

\item{DLEmodel}{the \code{\linkS4class{ModelTox}} object}

\item{DLEsamples}{the \code{\linkS4class{Samples}} object (can also be missing)}

\item{Effmodel}{the \code{\linkS4class{Effloglog}} or the \code{\linkS4class{EffFlexi}} object}

\item{Effsamples}{the \code{\linkS4class{Samples}} object (can also be missing)}

\item{\dots}{unused}
}
\description{
Compute the gain value with a given dose level, given a pseudo DLE model, a DLE sample,
a pseudo Efficacy log-log model and a Efficacy sample
}
\section{Methods (by class)}{
\itemize{
\item \code{dose = numeric,DLEmodel = ModelTox,DLEsamples = Samples,Effmodel = Effloglog,Effsamples = Samples}: 

\item \code{dose = numeric,DLEmodel = ModelTox,DLEsamples = Samples,Effmodel = EffFlexi,Effsamples = Samples}: Compute the gain given a dose level, a pseduo DLE model, a DLE sample,
the pseudo EffFlexi model and an Efficacy sample

\item \code{dose = numeric,DLEmodel = ModelTox,DLEsamples = missing,Effmodel = Effloglog,Effsamples = missing}: Compute the gain value given a dose level, a pseudo DLE model and a pseudo
efficacy model of \code{\linkS4class{Effloglog}} class object without DLE and the efficacy sample
}}
\examples{
##Obtain the gain value for a given dose, a pseudo DLE model, a DLE sample, 
## a pseudo efficacy model and an efficacy sample
##The DLE model must be from 'ModelTox' class (DLEmodel slot)
emptydata<- DataDual(doseGrid=seq(25,300,25))
data<-emptydata
DLEmodel<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)
DLEsamples <- mcmc(data, DLEmodel, McmcOptions(burnin=100,step=2,samples=200))

##The efficacy model must be from 'ModelEff' class (Effmodel slot)
## The DLE and efficayc samples must be from 'Samples' class (DLEsamples and Effsamples slot)
Effmodel<-Effloglog(Eff=c(1.223,2.513),Effdose=c(25,300),nu=c(a=0.025,b=1),data=data)
Effsamples <- mcmc(data, Effmodel, McmcOptions(burnin=100,step=2,samples=200))

## Given a dose level 75,
gain(dose=75,DLEmodel=DLEmodel,DLEsamples=DLEsamples,Effmodel=Effmodel,Effsamples=Effsamples)
##Obtain the gain value for a given dose, a pseudo DLE model, a DLE sample, 
## the 'EffFlexi' efficacy model and an efficacy sample
##The DLE model must be from 'ModelTox' class (DLEmodel slot)
emptydata<- DataDual(doseGrid=seq(25,300,25))
data<-emptydata
DLEmodel<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)
DLEsamples <- mcmc(data, DLEmodel, McmcOptions(burnin=100,step=2,samples=200))

##The efficacy model must be from 'EffFlexi' class (Effmodel slot)
## The DLE and efficayc samples must be from 'Samples' class (DLEsamples and Effsamples slot)
EffFleximodel <- EffFlexi(Eff=c(1.223, 2.513),Effdose=c(25,300),
                     sigma2=c(a=0.1,b=0.1),sigma2betaW=c(a=20,b=50),smooth="RW2",data=data)
Effsamples <- mcmc(data, EffFleximodel, McmcOptions(burnin=100,step=2,samples=200))

## Given a dose level 75,
gain(dose=75,DLEmodel=DLEmodel,DLEsamples=DLEsamples,Effmodel=EffFleximodel,Effsamples=Effsamples)
##Obtain the gain value for a given dose, a pseudo DLE model and  a pseudo efficacy model
## without samples
##The DLE model must be from 'ModelTox' class (DLEmodel slot)
emptydata<- DataDual(doseGrid=seq(25,300,25))
data<-Data(doseGrid=seq(25,300,25))

DLEmodel<-LogisticIndepBeta(binDLE=c(1.05,1.8),DLEweights=c(3,3),DLEdose=c(25,300),data=data)
##The efficacy model must be from 'Effloglog' class  (Effmodel slot)
Effmodel<-Effloglog(Eff=c(1.223,2.513),Effdose=c(25,300),nu=c(a=0.025,b=1),data=emptydata)
## Given a dose level 75,
gain(dose=75,DLEmodel=DLEmodel,Effmodel=Effmodel)
}
\keyword{methods}

