% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Samples-methods.R
\docType{methods}
\name{plot,DataDual,ModelEff-method}
\alias{plot,DataDual,ModelEff-method}
\title{Plot of the fitted dose-efficacy based with a given pseudo efficacy model and data without samples}
\usage{
\S4method{plot}{DataDual,ModelEff}(x, y, ..., xlab = "Dose level",
  ylab = "Expected Efficacy", showLegend = TRUE)
}
\arguments{
\item{x}{the data of \code{\linkS4class{DataDual}} class object}

\item{y}{the model of the \code{\linkS4class{ModelEff}} class object}

\item{xlab}{the x axis label}

\item{ylab}{the y axis label}

\item{showLegend}{should the legend be shown? (default)}

\item{\dots}{not used}
}
\value{
This returns the \code{\link[ggplot2]{ggplot}}
object for the dose-efficacy model plot
}
\description{
Plot of the fitted dose-efficacy based with a given pseudo efficacy model and data without samples
}
\examples{
##plot the dose-efficacy curve given a pseudo efficacy model using data without samples
##data must be of 'DataDual' class 
##define the data 
data<-DataDual(x=c(25,50,50,75,100,100,225,300),y=c(0,0,0,0,1,1,1,1),
               w=c(0.31,0.42,0.59,0.45,0.6,0.7,0.6,0.52),
               doseGrid=seq(25,300,25))
##model must be from 'ModelEff' class e.g 'Effloglog' class model
##define the model (see Effloglog example)
Effmodel<-Effloglog(Eff=c(1.223,2.513),Effdose=c(25,300),nu=c(a=0.025,b=1),data=data)
## plot the dose-efficacy curve
## 'x' is the data and 'y' is the model in plot
plot(x=data,y=Effmodel)
}
\keyword{methods}

