% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{DualEndpointBeta-class}
\alias{.DualEndpointBeta}
\alias{DualEndpointBeta-class}
\title{Dual endpoint model with beta function for dose-biomarker relationship}
\description{
This class extends the \code{\linkS4class{DualEndpoint}} class. Here the
dose-biomarker relationship \eqn{f(x)} is modelled by a parametric, rescaled
beta density function:
}
\details{
\deqn{f(x) = E_{0} + (E_{max} - E_{0}) * Beta(\delta_{1}, \delta_{2}) *
                  (x/x^{*})^{\delta_{1}} * (1 - x/x^{*})^{\delta_{2}}}

where \eqn{x^{*}} is the maximum dose (end of the dose range to be
considered), \eqn{\delta_{1}} and \eqn{\delta_{2}} are the two beta
parameters, and \eqn{E_{0}} and \eqn{E_{max}} are the minimum and maximum
levels, respectively. For ease of interpretation, we parametrize with
\eqn{\delta_{1}} and the mode of the curve instead, where
\deqn{mode = \delta_{1} / (\delta_{1} + \delta_{2}),}
and multiplying this with \eqn{x^{*}} gives the mode on the dose grid.

All parameters can currently be assigned uniform distributions or be fixed
in advance.
}
\section{Slots}{

\describe{
\item{\code{E0}}{either a fixed number or the two uniform distribution parameters}

\item{\code{Emax}}{either a fixed number or the two uniform distribution parameters}

\item{\code{delta1}}{either a fixed number or the two uniform distribution parameters}

\item{\code{mode}}{either a fixed number or the two uniform distribution parameters}

\item{\code{refDose}}{the reference dose \eqn{x^{*}}}
}}
\examples{

model <- DualEndpointBeta(E0 = c(0, 100),
                          Emax = c(0, 500),
                          delta1 = c(0, 5),
                          mode = c(1, 15),
                          refDose = 1000,
                          mu = c(0, 1),
                          Sigma = matrix(c(1, 0, 0, 1), nrow=2),
                          sigma2W = c(a=0.1, b=0.1),
                          rho = c(a=1, b=1))


}
\keyword{classes}

