% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Samples-methods.R
\docType{methods}
\name{plot,Samples,ModelEff-method}
\alias{plot,Samples,ModelEff-method}
\title{Plot the fitted dose-effcacy curve using a model from \code{\linkS4class{ModelEff}} class
with samples}
\usage{
\S4method{plot}{Samples,ModelEff}(x, y, data, ..., xlab = "Dose level",
  ylab = "Expected Efficacy", showLegend = TRUE)
}
\arguments{
\item{x}{the \code{\linkS4class{Samples}} object}

\item{y}{the \code{\linkS4class{ModelEff}} model class object}

\item{data}{the \code{\linkS4class{Data}} object}

\item{xlab}{the x axis label}

\item{ylab}{the y axis label}

\item{showLegend}{should the legend be shown? (default)}

\item{\dots}{not used}
}
\value{
This returns the \code{\link[ggplot2]{ggplot}}
object for the dose-efficacy model fit
}
\description{
Plot the fitted dose-effcacy curve using a model from \code{\linkS4class{ModelEff}} class
with samples
}
\examples{
## we need a data object with doses >= 1:
data <-DataDual(x=c(25,50,25,50,75,300,250,150),
                y=c(0,0,0,0,0,1,1,0),
                w=c(0.31,0.42,0.59,0.45,0.6,0.7,0.6,0.52),
                doseGrid=seq(25,300,25))
##plot the dose-efficacy curve with samples using the model from 'ModelEff' 
##class e.g. 'Effloglog' class model
##define the model (see Effloglog example)
Effmodel<-Effloglog(Eff=c(1.223,2.513),Effdose=c(25,300),nu=c(a=1,b=0.025),data=data)
## define the samples obtained using the 'Effloglog' model (see details in 'Samples' example)
##options for MCMC
options<-McmcOptions(burnin=100,step=2,samples=200)
## samples must be of 'Samples' class
samples <- mcmc(data=data,model=Effmodel,options=options)
## plot the fitted dose-efficacy curve including the 95\% credibility interval of the samples
## 'x' should be of 'Samples' class and 'y' of 'ModelEff' class
plot(x=samples,y=Effmodel,data=data)
}
\keyword{methods}

