% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McmcOptions-methods.R
\name{saveSample}
\alias{saveSample}
\title{Determine if we should save this sample}
\usage{
saveSample(iteration, mcmcOptions)
}
\arguments{
\item{iteration}{the current iteration index}

\item{mcmcOptions}{the \code{\linkS4class{McmcOptions}} object}
}
\value{
Logical value, if we should save this sample
}
\description{
Determine if we should save this sample
}
\examples{

# Set up MCMC option in order to have a burn-in of 10000 iterations and
# then take every other iteration up to a collection of 10000 samples
options <- McmcOptions(burnin=10000,
                       step=2,
                       samples=10000)

sampleSize(options)

saveSample(iteration=5,
           mcmcOptions=options)
}
\keyword{internal}
\keyword{programming}

