% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestNCRM-class}
\alias{NextBestNCRM-class}
\alias{.NextBestNCRM}
\title{The class with the input for finding the next dose in target interval}
\description{
Note that to avoid numerical problems, the dose selection algorithm has been
implemented as follows: First admissible doses are found, which are those
with probability to fall in \code{overdose} category being below
\code{maxOverdoseProb}. Next, within the admissible doses, the maximum
probability to fall in the \code{target} category is calculated. If that is
above 5\% (i.e., it is not just numerical error), then the corresponding
dose is the next recommended dose. Otherwise, the highest admissible dose is
the next recommended dose.
}
\section{Slots}{

\describe{
\item{\code{target}}{the target toxicity interval (limits included)}

\item{\code{overdose}}{the overdose toxicity interval (lower limit excluded, upper
limit included)}

\item{\code{maxOverdoseProb}}{maximum overdose probability that is allowed}
}}

\examples{

# In the example below, the target toxiciy interval [0.2, 0.35] while the 
# overdose interval is (0.35,1]. Finally we would like to constrain the probability
# of overdosing below 25\%.
myNextBest <- NextBestNCRM(target=c(0.2, 0.35),
                           overdose=c(0.35, 1),
                           maxOverdoseProb=0.25)


}
\keyword{classes}
