% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticKadane-class}
\alias{LogisticKadane-class}
\alias{.LogisticKadane}
\title{Reparametrized logistic model}
\description{
This is the logistic model in the parametrization of Kadane et al. (1980).
}
\details{
Let \eqn{\rho_{0} = p(x_{min})} be the probability of a DLT and the minimum
dose \eqn{x_{min}}, and let \eqn{\gamma} be the dose with target toxicity
probability \eqn{\theta}, i.e. \eqn{p(\gamma) = \theta}. Then it can easily
be shown that the logistic regression model has intercept
\deqn{\frac{\gamma logit(\rho_{0}) - x_{min} logit(\theta)}{\gamma -
x_{min}}}{(\gamma logit(\rho_{0}) - x_{min} logit(\theta)) / (\gamma -
x_{min})}
and slope
\deqn{\frac{logit(theta) - logit(\rho_{0})}{\gamma - x_{min}}}{(logit(theta)
- logit(\rho_{0})) / (\gamma - x_{min})}

The prior is a uniform distribution for \eqn{\gamma} between \eqn{x_{min}}
and \eqn{x_{max}}, and for \eqn{\rho_{0}} as well a uniform distribution
between \eqn{0} and \eqn{\theta}.

The slots of this class, required for creating the model, are the target
toxicity, as well as the minimum and maximum of the dose range. Note that
these can be different from the minimum and maximum of the dose grid in the
data later on.
}
\section{Slots}{

\describe{
\item{\code{theta}}{the target toxicity probability \eqn{\theta}}

\item{\code{xmin}}{the minimum of the dose range \eqn{x_{min}}}

\item{\code{xmax}}{the maximum of the dose range \eqn{x_{max}}}
}}

\examples{


model <- LogisticKadane(theta = 0.33,
                        xmin = 1,
                        xmax = 200)


}
\keyword{classes}
