% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-class.R
\name{Data}
\alias{Data}
\title{Initialization function for the "Data" class}
\usage{
Data(
  x = numeric(),
  y = integer(),
  ID = integer(),
  cohort = integer(),
  doseGrid = numeric(),
  placebo = FALSE,
  ...
)
}
\arguments{
\item{x}{the doses for the patients}

\item{y}{the vector of toxicity events (0 or 1 integers). You can also
normal numeric vectors, but these will then be converted to integers.}

\item{ID}{unique patient IDs (integer vector)}

\item{cohort}{the cohort indices (sorted values from 0, 1, 2, ...)}

\item{doseGrid}{the vector of all possible doses}

\item{placebo}{logical value: if TRUE the first dose level in the grid is 
considered as PLACEBO}

\item{\dots}{not used}
}
\value{
the initialized \code{\linkS4class{Data}} object
}
\description{
This is the function for initializing a "Data" class object.
}
\details{
Note that \code{ID} and \code{cohort} can be missing, then a warning
will be issued and the variables will be filled with default
IDs and best guesses, respectively.
}
\keyword{programming}
