% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{load_data}
\alias{load_data}
\title{Load observed structure factors from 1D structure data in workspace.}
\usage{
load_data(sname = NULL)
}
\arguments{
\item{sname}{A character string. Name of the structure whose data
are to be loaded in the workspace. It can be one of:
\itemize{
  \item{beryllium_fluoride}
  \item{carbon_dioxide}
  \item{cyanate}
  \item{nitronium}
  \item{thiocyanate}
  \item{xenon_difluoride}
  \item{pinkerton2015}
}
Default is NULL, in which case the function returns a list of all
structures available.}
}
\value{
A named fdata-type list with the following elements:
 \itemize{
   \item{a    Real numeric. Unit cell length in angstroms. Always 
              included.}
   \item{SG.   Spacegroup 2-letters character string. There are only two 
               symmetries possible when working within 1D 
               crystallography, P1 (no symmetry) and P-1 (inversion 
               through the origin). SG can be either "P1" or "P-1". 
               Always included.}
   \item{hidx. Real numeric array. 1D unique (positive in the 1D context) 
               Miller indices. Always included.}
   \item{Fobs.      Real numeric array. Amplitudes of observed structure 
                    factors. Not always included.}
   \item{sigFobs.   Real numeric array. Errors associated with Fobs. Not 
                    always included.}
   \item{Phicalc.   Real numeric array. Phases (in degrees) of structure 
                    factors calculated from the correct 1D structure. 
                    They are normally used to check correctness of 
                    Phiobs. Not always included.}
         }
}
\description{
Function to load structure factors corresponding to one of the many 1D 
structures available within the \emph{crone} package. The structure
factors amplitudes have been generated from calculated data with some
simulated error, so that they mimic observed data. Phases are calculated
from the correct structure.
}
\examples{
# Load thiocyanate data
fdata <- load_data("thiocyanate")
print(fdata)

# Default returns all names of structures included
load_data()

}
