% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{crop}
\alias{crop}
\alias{circle_crop}
\alias{square_crop}
\alias{hex_crop}
\alias{heart_crop}
\title{Cropping functions}
\usage{
circle_crop(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  just = "center"
)

square_crop(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  just = "center"
)

hex_crop(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  just = "center"
)

heart_crop(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  just = "center"
)
}
\arguments{
\item{images}{Vector of image paths, either local or urls. If urls the images
will be downloaded first.}

\item{to}{Path to new location}

\item{border_size}{Border size in pixels.}

\item{border_colour}{Border colour.}

\item{just}{Where to justify the image prior to cropping. Accepted values: `left`, `right`, `top`, `bottom`}
}
\value{
Path to cropped images
}
\description{
Reads in an image and crops to the specified geometry with a transparent
background. If a new path is given it will save the cropped images to
the new location. If no path is given it will save to a temporary location
which will be cleared when the session is closed
}
\examples{
library(cropcircles)
library(magick)

img_path <- file.path(system.file(package = "cropcircles"), "images", "walter-jesse.png")
img_cropped <- circle_crop(img_path, border_size = 6)
image_read(img_cropped)

# other geometries

image_read(hex_crop(img_path, border_size = 6))
image_read(heart_crop(img_path, border_size = 6))

# justification example

# center (default)
image_read(circle_crop(img_path, border_size = 6))

# left
image_read(circle_crop(img_path, border_size = 6, just = "left"))

# right
image_read(circle_crop(img_path, border_size = 6, just = "right"))
}
