% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/day_of_year.R
\name{day_of_harvest}
\alias{day_of_harvest}
\title{The day of harvest in the year of sowing}
\usage{
day_of_harvest(
  x,
  sowing,
  type = c("calendar", "financial", "other"),
  base = NULL
)
}
\arguments{
\item{x}{A harvest \code{\link{Date}} used for calculation of the day of the year.}

\item{sowing}{A sowing \code{\link{Date}} used for calculation.}

\item{type}{A character string specifying the type of
year. \dQuote{calendar} is a calendar year starting on 1
January, \dQuote{financial} an Australian financial year
beginning on 1 June and \dQuote{other} is for a year starting on
another date which is specified in \code{base}. Default:
\dQuote{calendar}}

\item{base}{A \code{list} specifying the day and month of the
first day to be used in calculations. The name of the day
component must be named either \dQuote{day} or \dQuote{d}, and
the month must be named either \dQuote{month} or \dQuote{m}.}
}
\value{
An \code{numeric} vector containing the day of harvest in
the year of sowing which will differ from the day of harvest if
the sowing date is in the previous year
}
\description{
\code{day_of_harvest} calculates day of year if harvest goes past
end of year (or not). For instance, if the sowing date is at the
end of the year, then the harvest date early in the next year (as
a day of year) will be be smaller than the sowing date (as a day
of the year). This function rectifies this situation by
calculating the harvest date as the day of year in the previous
year and so would be greater than 366 in this instance. Of course,
this is not necessary if the sowing and harvest dates are in the
same year.
}
\examples{
library(lubridate)
day_of_harvest(x = ymd("2020-06-15"), sowing = ymd("2020-06-01"))
day_of_harvest(x = ymd("2021-06-15"), sowing = ymd("2021-06-01"))
day_of_harvest(x = ymd("2021-06-15"), sowing = ymd("2020-06-01"))
day_of_harvest(x = ymd("2021-02-05"), sowing = ymd("2021-01-28"))
day_of_harvest(x = ymd("2021-02-05"), sowing = ymd("2021-01-28"),
               type = "financial")
day_of_harvest(x = ymd("2021-02-05"), sowing = ymd("2021-01-28"),
               type = "other", base = list(m = 9, day = 1))
}
