% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/right_phenoplot.R
\name{build_right_phenoplot}
\alias{build_right_phenoplot}
\title{Right SNP-pheno phenoplot}
\usage{
build_right_phenoplot(HapObject, epsilon, hide_labels = TRUE)
}
\arguments{
\item{HapObject}{Haplotype object created by run_haplotyping().}

\item{epsilon}{Epsilon to visualize haplotyping results for.}

\item{hide_labels}{If TRUE, legend is hidden.}
}
\value{
A ggplot2 object.
}
\description{
build_right_phenoplot() builds a horizontal plot displaying the mean
difference in phenotype score between individuals with the alternate vs
reference alleles for each SNP locus, grouped by marker group, coloured by
the alternate allele frequency of each SNP. Makes use of the $Varfile
phenotypic information from haplotyping object. It is an internal function
called by crosshap_viz(), though can be called separately to build a
stand-alone plot.
}
\examples{
    build_right_phenoplot(HapObject, epsilon = 0.6, hide_labels = FALSE)

}
