% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosshapviz_wrapper.R
\name{crosshap_viz}
\alias{crosshap_viz}
\title{Visualize haplotypes}
\usage{
crosshap_viz(
  HapObject,
  epsilon,
  plot_left = "allele",
  plot_right = "pheno",
  hide_labels = FALSE,
  isolate_group = NA
)
}
\arguments{
\item{HapObject}{Haplotype object created by run_haplotyping().}

\item{epsilon}{Epsilon to visualize haplotyping results for.}

\item{plot_left}{When plot_left = "allele", SNP allele frequency information
is displayed, when plot_left = "pos", SNP position information is displayed.}

\item{plot_right}{When plot_right = "pheno", phenotype associations for SNPs
are displayed, when plot_right = "cluster", internal marker group linkage is
displayed.}

\item{hide_labels}{When TRUE, legends from plots are hidden.}

\item{isolate_group}{If one or more Metadata groups are provided, all other
Metadata groups will be masked from the plot. NOTE: it does change the
summary tables or marker group phenotype scores.}
}
\value{
A patchwork object.
}
\description{
crosshap_viz() builds five individual plots using various elements of a
HapObject created by run_haplotyping(). The central dotplot displays
relationship between clusters of linked SNPs (Marker Groups), and distinct
haplotypes present within the population. Vertical plots (top/bottom)
visualize individuals and populations, grouped by haplotype. Horizontal plots
(left/right) visualize SNP information, grouped by Marker Group cluster.
}
