% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/left_alleleplot.R
\name{build_left_alleleplot}
\alias{build_left_alleleplot}
\title{Left SNP-allele plot}
\usage{
build_left_alleleplot(HapObject, epsilon, hide_labels = TRUE)
}
\arguments{
\item{HapObject}{Haplotype object created by run_haplotyping().}

\item{epsilon}{Epsilon matching the haplotype object used for umap_in.}

\item{hide_labels}{If TRUE, legend is hidden.}
}
\value{
A ggplot2 object.
}
\description{
build_left_alleleplot() builds a horizontal plot displaying mean allelic
frequencies (reference/alternate/missing/heterozygous) of all SNP loci,
grouped by marker group. Makes use of $Varfile information from a HapObject
created by run_haplotyping(). This is an internal function called by
crosshap_viz(), though can be called separately to build a stand-alone plot.
}
\examples{
build_left_alleleplot(HapObject, epsilon = 0.6, hide_labels = FALSE)

}
