% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_crs.R
\name{crs_epsg}
\alias{crs_epsg}
\title{Extract 'EPSG' value}
\usage{
crs_epsg(x, ...)
}
\arguments{
\item{x}{object with 'EPSG' value}

\item{...}{ignored}
}
\value{
integer (or NA)
}
\description{
Obtain the 'EPSG' string from an object, if it has one. Supported inputs
include sf.
}
\examples{
crs_epsg(sfx)
x <- sfx
attr(x$geom, "crs")$epsg <- NA ## oh no we lost it
crs_epsg(x)
}
\references{
\href{http://www.epsg.org/}{EPSG website}
}
\seealso{
\code{\link[=crs_wkt2]{crs_wkt2()}} \code{\link[=crs_proj]{crs_proj()}}
}
