% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crunchy-server.R
\name{crunchyServer}
\alias{crunchyServer}
\title{A Shiny server with Crunch auth}
\usage{
crunchyServer(func, authz = getOption("crunchy.authorization"))
}
\arguments{
\item{func}{A \code{function (input, output, session)}, as you'd normally give to
\code{shinyServer()}. If the user is not authenticated or authorized, this
function will not be evaluated.}

\item{authz}{A \code{function (input, output, session)} to evaluate
to determine if the current user is authorized to enter the app.
Since it will be called repeatedly, it should be cheap to execute.}
}
\value{
Invisibly, a Shiny server function with the auth logic wrapped around
\code{func}.
}
\description{
To make sure that users who access your shiny.crunch.io app are allowed to
access it, use \code{crunchyServer()} instead of \code{\link[shiny:shinyServer]{shiny::shinyServer()}}, and wrap
your UI content inside \code{\link[=crunchyBody]{crunchyBody()}}. This will prevent anyone who is not
logged into Crunch in their browser from accessing your app.
}
\details{
To restrict access further to only certain Crunch users, you can set an
authorization method, either by passing a server function to
the \code{authz} argument of this function, or by calling
\code{\link[=setCrunchyAuthorization]{setCrunchyAuthorization()}}.

For a simple example app using \code{crunchyServer()}, copy
\code{system.file("example_apps/crunchy_server/app.R", package="crunchy")},
supply your dataset id on line 14, and run it.
}
\seealso{
\code{\link[=crunchyBody]{crunchyBody()}} for wrapping the UI contents, \code{\link[=crunchyPublicBody]{crunchyPublicBody()}}
for specifying an alternate UI for when the user is not authenticated,
\code{\link[=crunchyUnauthorizedBody]{crunchyUnauthorizedBody()}} for giving an alternate UI for users who are
authenticated with Crunch but not authorized to view this app, and
\code{\link[=setCrunchyAuthorization]{setCrunchyAuthorization()}} for governing who is authorized to view
your app.
}
