% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper.R
\name{scraper}
\alias{scraper}
\title{Historical table scraper}
\usage{
scraper(attributes, slug)
}
\arguments{
\item{attributes}{URL generated from \code{listCoins()}}

\item{slug}{Unique identifier required for merging}
}
\value{
Raw OHLC market data in a dataframe:
  \item{slug}{Coin url slug}
  \item{symbol}{Coin symbol}
  \item{name}{Coin name}
  \item{date}{Market date}
  \item{open}{Market open}
  \item{high}{Market high}
  \item{low}{Market low}
  \item{close}{Market close}
  \item{volume}{Volume 24 hours}
  \item{market}{USD Market cap}

This function is not to be called individually by a user but is to be
consumed as part of the getCoins.
}
\description{
This web scrapes the historic price tables from CoinMarketCap
and provides back a dataframe for the coin provided as an input.
This function is a dependency of getCoins and is used
as part of a loop to retrieve all crypto currencies.
}
\examples{
\dontrun{
# Only to be executed by getCoins
scraper(attributes)
}

}
