% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_markets.R
\name{daily_market}
\alias{daily_market}
\title{Daily cryptocurrency market data}
\usage{
daily_market(coin = NULL)
}
\arguments{
\item{coin}{Name, symbol or slug of crypto currency}
}
\value{
Daily timeseries of token data in a dataframe:
  \item{timestamp}{Timestamp (POSIXct)}
  \item{market_cap}{Market Cap in USD}
  \item{price_btc}{Price in BTC}
  \item{price_usd}{Price in USD}
  \item{volume}{Volume traded in USD}
  \item{slug}{Coin URL slug (unique)}
}
\description{
Retrieve timeseries of market_cap, price_btc, price_usd and volume
of specified coin - perfect for charting or timeseries analysis.
}
\details{
Most tokens are refreshed every 6 hours.. results may vary.
}
\examples{
\dontrun{
coin       <- "kin"
kin_charts <- daily_market(coin)
}
}
