% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fgi.R
\name{get_fgindex}
\alias{get_fgindex}
\title{Get the daily Fear and Greed Index
for the cryptocurrency market}
\usage{
get_fgindex(from = NULL, to = NULL)
}
\arguments{
\item{from}{An optional \link{character}, \link{date} or \link{POSIXct} vector of \link{length} 1. \link{NULL} by default.}

\item{to}{An optional \link{character}, \link{date} or \link{POSIXct} vector of \link{length} 1. \link{NULL} by default.}
}
\value{
An \link{xts}-object containing,
\itemize{
\item fgi (\link{numeric}): The daily fear and greed index value
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

The fear and greed index is a market sentiment indicator that measures investor emotions to
gauge whether they are generally fearful (indicating potential selling pressure) or greedy (indicating potential buying enthusiasm)
}
\details{
\subsection{On time-zones and dates}{

Values passed to \code{from} or \code{to} must be coercible by \code{\link[=as.Date]{as.Date()}}, or \code{\link[=as.POSIXct]{as.POSIXct()}}, with a format of either \code{"\%Y-\%m-\%d"} or \code{"\%Y-\%m-\%d \%H:\%M:\%S"}. By default
all dates are passed and returned with \code{\link[=Sys.timezone]{Sys.timezone()}}.
}

\subsection{On returns}{

If only \code{from} is provided 200 pips are returned up to \code{Sys.time()}. If only \code{to} is provided 200 pips up to the specified date
is returned.
}
}
\note{
The Fear and Greed Index goes from 0-100, and can be classified as follows,

\itemize{
\item 0-24, Extreme Fear
\item 25-44, Fear
\item 45-55, Neutral
\item 56-75, Greed
\item 76-100, Extreme Greed
}
}
\examples{
\dontrun{
  # script: Fear and Greed Index
  # date: 2023-12-26
  # author: Serkan Korkmaz, serkor1@duck.com
  # objective: Retrieve and Plot the
  # index
  # script start;

  # 1) get the fear and greed index
  # for the last 7 days
  tail(
    fgi <- cryptoQuotes::get_fgindex(
      from = Sys.Date() - 7
    )
  )

  # script end;
}

}
\seealso{
Other get-function: 
\code{\link{get_fundingrate}()},
\code{\link{get_lsratio}()},
\code{\link{get_openinterest}()},
\code{\link{get_quote}()}
}
\author{
Serkan Korkmaz
}
\concept{get-function}
